/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.catalog.gdg.GDGManager;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.node.resources.custom.ResourceDefinition;
import org.pepstock.jem.node.rmi.CommonResourcer;
import org.pepstock.jem.node.tasks.InitiatorManager;
import org.pepstock.jem.node.tasks.jndi.DataStreamReference;
import org.pepstock.jem.node.tasks.jndi.FtpReference;
import org.pepstock.jem.node.tasks.jndi.HttpReference;
import org.pepstock.jem.node.tasks.jndi.JdbcReference;
import org.pepstock.jem.node.tasks.jndi.JmsReference;
import org.pepstock.jem.node.tasks.jndi.JppfReference;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.DataDescription;
import org.pepstock.jem.springbatch.tasks.DataSource;
import org.pepstock.jem.springbatch.tasks.Lock;
import org.pepstock.jem.springbatch.tasks.Property;
import org.pepstock.jem.springbatch.tasks.SpringBatchSecurityManager;
import org.pepstock.jem.springbatch.tasks.managers.ImplementationsContainer;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public abstract class JemTasklet
implements Tasklet {
    private ArrayList<DataDescription> dataDescriptionList = new ArrayList();
    private ArrayList<DataSource> dataSourceList = new ArrayList();
    private ArrayList<Lock> locks = new ArrayList();

    public ArrayList<DataDescription> getDataDescriptionList() {
        return this.dataDescriptionList;
    }

    public void setDataDescriptionList(ArrayList<DataDescription> dataDescriptionList) {
        this.dataDescriptionList = dataDescriptionList;
    }

    public ArrayList<DataSource> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(ArrayList<DataSource> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    public ArrayList<Lock> getLocks() {
        return this.locks;
    }

    public void setLocks(ArrayList<Lock> locks) {
        this.locks = locks;
    }

    public final RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        RepeatStatus status;
        block36: {
            StringBuffer exceptions;
            boolean isExecutionStarted = false;
            SpringBatchSecurityManager batchSM = (SpringBatchSecurityManager)System.getSecurityManager();
            batchSM.setInternalAction(true);
            System.setProperty("java.naming.factory.initial", "org.pepstock.jem.node.tasks.jndi.JemContextFactory");
            status = null;
            StepContext stepContext = chunkContext.getStepContext();
            List<DataDescriptionImpl> dataDescriptionImplList = ImplementationsContainer.getInstance().getDataDescriptionsByItem(stepContext.getStepName());
            try {
                InitialContext ic = new InitialContext();
                for (DataSource source : this.dataSourceList) {
                    if (source.getName() == null || source.getResource() == null) {
                        throw new Exception(SpringBatchMessage.JEMS016E.toMessage().getFormattedMessage(new Object[0]));
                    }
                    CommonResourcer resourcer = InitiatorManager.getCommonResourcer();
                    Resource res = resourcer.lookup(source.getResource());
                    if (!batchSM.checkResource(res)) {
                        throw new Exception(SpringBatchMessage.JEMS017E.toMessage().getFormattedMessage(res.toString()));
                    }
                    HashMap<String, ResourceProperty> properties = res.getProperties();
                    for (Property property : source.getProperties()) {
                        for (ResourceProperty resProperty : properties.values()) {
                            if (!resProperty.getName().equalsIgnoreCase(property.getName()) || resProperty.isOverride()) continue;
                            throw new Exception(SpringBatchMessage.JEMS018E.toMessage().getFormattedMessage(property.getName(), res));
                        }
                        res.setProperty(property.getName(), property.getValue());
                    }
                    Reference ref = null;
                    if (res.getType().equalsIgnoreCase("jdbc")) {
                        ref = new JdbcReference();
                    } else if (res.getType().equalsIgnoreCase("jppf")) {
                        ref = new JppfReference();
                    } else if (res.getType().equalsIgnoreCase("jms")) {
                        ref = new JmsReference();
                    } else if (res.getType().equalsIgnoreCase("http")) {
                        ref = new HttpReference();
                    } else if (res.getType().equalsIgnoreCase("ftp")) {
                        ref = new FtpReference();
                        for (DataDescriptionImpl ddImpl : dataDescriptionImplList) {
                            for (DataSetImpl ds : ddImpl.getDataSetsImpl()) {
                                if (ds.getType() != 6 || !ds.getDataSource().equalsIgnoreCase(source.getName())) continue;
                                res.setProperty("remoteFile", ds.getName());
                                if (!ddImpl.getDisposition().equalsIgnoreCase("SHR")) {
                                    res.setProperty("action", "write");
                                    continue;
                                }
                                res.setProperty("action", "read");
                            }
                        }
                    }
                    if (!Main.CUSTOM_RESOURCE_DEFINITION_MANAGER.hasCustomResourceDefinition(res.getType())) {
                        throw new Exception(SpringBatchMessage.JEMS019E.toMessage().getFormattedMessage(res.getName(), res.getType()));
                    }
                    ResourceDefinition resourceDefinition = Main.CUSTOM_RESOURCE_DEFINITION_MANAGER.getCustomResourceDefinition(res.getType());
                    ref = resourceDefinition.getResourceReference();
                    for (ResourceProperty property : properties.values()) {
                        ref.add(new StringRefAddr(property.getName(), property.getValue()));
                    }
                    System.out.println(SpringBatchMessage.JEMS024I.toMessage().getFormattedMessage(res));
                    ic.rebind(source.getName(), (Object)ref);
                }
                if (!dataDescriptionImplList.isEmpty()) {
                    for (DataDescriptionImpl ddImpl : dataDescriptionImplList) {
                        DataStreamReference reference = new DataStreamReference();
                        GDGManager.load(ddImpl);
                        XStream xstream = new XStream();
                        String xml = xstream.toXML((Object)ddImpl);
                        reference.add(new StringRefAddr("jem.datadescrition.object", xml));
                        System.out.println(SpringBatchMessage.JEMS023I.toMessage().getFormattedMessage(ddImpl));
                        ic.rebind(ddImpl.getName(), (Object)reference);
                    }
                }
                batchSM.setInternalAction(false);
                isExecutionStarted = true;
                status = this.run(stepContribution, chunkContext);
                batchSM.setInternalAction(true);
                if (dataDescriptionImplList.isEmpty()) break block36;
                exceptions = new StringBuffer();
            }
            catch (Exception e1) {
                try {
                    throw e1;
                }
                catch (Throwable throwable) {
                    batchSM.setInternalAction(true);
                    if (!dataDescriptionImplList.isEmpty()) {
                        StringBuffer exceptions2 = new StringBuffer();
                        for (DataDescriptionImpl ddImpl : dataDescriptionImplList) {
                            try {
                                if (!isExecutionStarted) continue;
                                GDGManager.store(ddImpl);
                            }
                            catch (IOException e) {
                                System.out.println(SpringBatchMessage.JEMS025E.toMessage().getFormattedMessage(e.getMessage()));
                                if (exceptions2.length() == 0) {
                                    exceptions2.append(SpringBatchMessage.JEMS025E.toMessage().getFormattedMessage(e.getMessage()));
                                    continue;
                                }
                                exceptions2.append(SpringBatchMessage.JEMS025E.toMessage().getFormattedMessage(e.getMessage())).append("\n");
                            }
                        }
                        if (exceptions2.length() > 0) {
                            throw new Exception(exceptions2.toString());
                        }
                    }
                    throw throwable;
                }
            }
            for (DataDescriptionImpl ddImpl : dataDescriptionImplList) {
                try {
                    if (!isExecutionStarted) continue;
                    GDGManager.store(ddImpl);
                }
                catch (IOException e) {
                    System.out.println(SpringBatchMessage.JEMS025E.toMessage().getFormattedMessage(e.getMessage()));
                    if (exceptions.length() == 0) {
                        exceptions.append(SpringBatchMessage.JEMS025E.toMessage().getFormattedMessage(e.getMessage()));
                        continue;
                    }
                    exceptions.append(SpringBatchMessage.JEMS025E.toMessage().getFormattedMessage(e.getMessage())).append("\n");
                }
            }
            if (exceptions.length() > 0) {
                throw new Exception(exceptions.toString());
            }
        }
        return status;
    }

    public abstract RepeatStatus run(StepContribution var1, ChunkContext var2) throws Exception;
}

