/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.catalog.gdg.GDGUtil;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class DataSet
extends AbstractResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataSetImpl dataSetImpl = new DataSetImpl();
    private String path;
    private String name = null;
    private int offset = Integer.MIN_VALUE;
    private String textBuffer = "";
    private String datasource = null;
    private boolean replaceProperties = false;

    public DataSet() {
        this.path = System.getProperty("jem.data");
        if (this.path == null) {
            throw new RuntimeException(SpringBatchMessage.JEMS001E.toMessage().getFormattedMessage(new Object[0]));
        }
    }

    public DataSetImpl getDataSetImpl() {
        return this.dataSetImpl;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.trim().length() == 0) {
            throw new RuntimeException(SpringBatchMessage.JEMS029E.toMessage().getFormattedMessage(new Object[0]));
        }
        try {
            Object[] objects = GDGUtil.isGDG(name);
            this.name = objects[0].toString();
            this.offset = Integer.parseInt(objects[1].toString());
        }
        catch (ParseException e) {
            this.name = name;
            this.offset = Integer.MIN_VALUE;
        }
        this.dataSetImpl.setName(name);
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isTemporary() {
        if (this.name != null) {
            return this.name.startsWith("@@") && !this.isInline();
        }
        return false;
    }

    public void setText(String text) {
        this.textBuffer = text;
    }

    public String getText() {
        return this.textBuffer;
    }

    public boolean isImplemented() {
        return this.dataSetImpl.getFile() != null;
    }

    public boolean isInline() {
        return this.textBuffer.length() > 0;
    }

    public boolean isGdg() {
        return this.offset != Integer.MIN_VALUE && !this.isDefinedDatasource();
    }

    public boolean isDefinedDatasource() {
        return this.datasource != null;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        if (datasource.trim().length() == 0) {
            throw new RuntimeException(SpringBatchMessage.JEMS012E.toMessage().getFormattedMessage(new Object[0]));
        }
        this.datasource = datasource;
    }

    public boolean isReplaceProperties() {
        return this.replaceProperties;
    }

    public void setReplaceProperties(boolean replaceProperties) {
        this.replaceProperties = replaceProperties;
    }

    public boolean exists() {
        return this.dataSetImpl.getRealFile().exists();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.dataSetImpl.getRealFile());
    }

    public URL getURL() throws IOException {
        return this.dataSetImpl.getRealFile().toURI().toURL();
    }

    public File getFile() {
        return this.dataSetImpl.getRealFile();
    }

    public Resource createRelative(String relativePath) {
        return null;
    }

    public String getFilename() {
        return this.dataSetImpl.getRealFile().getAbsolutePath();
    }

    public String getDescription() {
        return "file [" + this.dataSetImpl.getRealFile().getAbsolutePath() + "]";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DataSet && this.dataSetImpl.getRealName().equals(((DataSet)obj).getDataSetImpl().getRealName());
    }

    public int hashCode() {
        return this.dataSetImpl.hashCode();
    }

    public String toString() {
        if (this.isInline()) {
            return "content=" + this.textBuffer;
        }
        return "dsn=" + this.name;
    }
}

