/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.items;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.core.io.Resource;

public class SimpleFileItemWriter
implements ResourceAwareItemWriterItemStream<String> {
    private Resource resource;
    private int lineCount = 0;
    private boolean noOutput = false;
    private PrintWriter writer = null;

    public void close() throws ItemStreamException {
        this.lineCount = 0;
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.noOutput = true;
        if (this.resource == null) {
            throw new ItemStreamException(SpringBatchMessage.JEMS033E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (this.resource instanceof DataSet) {
            DataSet ds = (DataSet)this.resource;
            try {
                this.writer = new PrintWriter(new FileWriter(ds.getDataSetImpl().getRealFile()));
            }
            catch (IOException e) {
                throw new ItemStreamException((Throwable)e);
            }
        } else {
            throw new ItemStreamException(SpringBatchMessage.JEMS033E.toMessage().getFormattedMessage(new Object[0]));
        }
        this.noOutput = false;
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void write(List<? extends String> records) throws Exception {
        if (this.noOutput) {
            return;
        }
        for (String string : records) {
            this.writer.println(string);
            ++this.lineCount;
        }
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

