/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.items;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.core.io.Resource;

public class SimpleFileItemReader
implements ResourceAwareItemReaderItemStream<String> {
    private Resource resource;
    private int lineCount = 0;
    private boolean noInput = false;
    private LineNumberReader reader = null;

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void close() throws ItemStreamException {
        this.lineCount = 0;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new ItemStreamException((Throwable)e);
            }
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.noInput = true;
        if (this.resource == null) {
            throw new ItemStreamException(SpringBatchMessage.JEMS033E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (!this.resource.exists()) {
            throw new ItemStreamException(SpringBatchMessage.JEMS033E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (!this.resource.isReadable()) {
            throw new ItemStreamException(SpringBatchMessage.JEMS033E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (this.resource instanceof DataSet) {
            DataSet ds = (DataSet)this.resource;
            try {
                this.reader = new LineNumberReader(new FileReader(ds.getDataSetImpl().getRealFile()));
            }
            catch (FileNotFoundException e) {
                throw new ItemStreamException((Throwable)e);
            }
        } else {
            throw new ItemStreamException(SpringBatchMessage.JEMS033E.toMessage().getFormattedMessage(new Object[0]));
        }
        this.noInput = false;
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public String read() throws Exception {
        if (this.noInput) {
            return null;
        }
        if (this.reader == null) {
            throw new UnexpectedInputException(SpringBatchMessage.JEMS034E.toMessage().getFormattedMessage(new Object[0]));
        }
        String line = null;
        try {
            line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            ++this.lineCount;
        }
        catch (IOException e) {
            this.noInput = true;
            throw e;
        }
        return line;
    }
}

