/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.items;

import java.util.List;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.items.DataDescriptionItem;
import org.pepstock.jem.springbatch.tasks.DataDescription;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.core.io.Resource;

public class DataDescriptionItemWriter<T>
implements ResourceAwareItemWriterItemStream<T>,
StepExecutionListener,
DataDescriptionItem {
    private DataDescription dataDescription = null;
    private DataDescriptionImpl dataDescriptionImpl = null;
    private Resource resource = null;
    private String stepName = null;
    private ResourceAwareItemWriterItemStream<? super T> delegate;

    @Override
    public DataDescription getDataDescription() {
        return this.dataDescription;
    }

    @Override
    public void setDataDescription(DataDescription dataDescription) {
        this.dataDescription = dataDescription;
        if (dataDescription.getDisposition().equalsIgnoreCase("SHR")) {
            throw new RuntimeException(SpringBatchMessage.JEMS030E.toMessage().getFormattedMessage(dataDescription.getName(), dataDescription.getDisposition()));
        }
        if (dataDescription.isMultiDataset()) {
            throw new RuntimeException(SpringBatchMessage.JEMS004E.toMessage().getFormattedMessage(dataDescription.getName(), dataDescription.getDisposition()));
        }
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public DataDescriptionImpl getDataDescriptionImpl() {
        return this.dataDescriptionImpl;
    }

    @Override
    public void setDataDescriptionImpl(DataDescriptionImpl dataDescriptionImpl) {
        this.dataDescriptionImpl = dataDescriptionImpl;
    }

    @Override
    public void setResources(Resource[] resources) {
        if (resources != null) {
            if (resources.length != 1) {
                throw new IllegalArgumentException(SpringBatchMessage.JEMS031E.toMessage().getFormattedMessage(resources.length));
            }
        } else {
            throw new IllegalArgumentException(SpringBatchMessage.JEMS031E.toMessage().getFormattedMessage(0));
        }
        this.setResource(resources[0]);
    }

    public void setDelegate(ResourceAwareItemWriterItemStream<? super T> delegate) {
        this.delegate = delegate;
    }

    public void close() throws ItemStreamException {
        this.delegate.close();
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.delegate == null) {
            throw new ItemStreamException(SpringBatchMessage.JEMS032E.toMessage().getFormattedMessage(new Object[0]));
        }
        this.delegate.setResource(this.resource);
        this.delegate.open(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.update(executionContext);
    }

    public void write(List<? extends T> item) throws Exception {
        this.delegate.write(item);
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepName = stepExecution.getStepName();
    }
}

