/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch.items;

import java.io.IOException;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.items.DataDescriptionItem;
import org.pepstock.jem.springbatch.tasks.DataDescription;
import org.pepstock.jem.springbatch.tasks.DataSet;
import org.pepstock.jem.springbatch.tasks.managers.DataSetManager;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.MultiResourceItemReader;
import org.springframework.core.io.Resource;

public class DataDescriptionItemReader<T>
extends MultiResourceItemReader<T>
implements StepExecutionListener,
DataDescriptionItem {
    private DataDescription dataDescription = null;
    private DataDescriptionImpl dataDescriptionImpl = null;
    private String stepName = null;

    @Override
    public DataDescription getDataDescription() {
        return this.dataDescription;
    }

    @Override
    public void setDataDescription(DataDescription dataDescription) {
        this.dataDescription = dataDescription;
        if (!dataDescription.getDisposition().equalsIgnoreCase("SHR")) {
            throw new RuntimeException(SpringBatchMessage.JEMS006E.toMessage().getFormattedMessage(dataDescription.getName(), dataDescription.getDisposition()));
        }
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public DataDescriptionImpl getDataDescriptionImpl() {
        return this.dataDescriptionImpl;
    }

    @Override
    public void setDataDescriptionImpl(DataDescriptionImpl dataDescriptionImpl) {
        this.dataDescriptionImpl = dataDescriptionImpl;
    }

    public T read() throws Exception, UnexpectedInputException, ParseException {
        Object item;
        try {
            item = super.read();
        }
        catch (UnexpectedInputException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return (T)item;
    }

    @Override
    public void setResources(Resource[] resources) {
        for (Resource resource : resources) {
            DataSet ds;
            if (!(resource instanceof DataSet) || (ds = (DataSet)resource).isImplemented()) continue;
            try {
                DataSetManager.createDataSetImpl(ds);
            }
            catch (IOException e) {
                System.out.println(SpringBatchMessage.JEMS037W.toMessage().getFormattedMessage(ds.toString()));
            }
            catch (Exception e) {
                System.out.println(SpringBatchMessage.JEMS037W.toMessage().getFormattedMessage(ds.toString()));
            }
        }
        super.setResources(resources);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public final void beforeStep(StepExecution stepExecution) {
        this.stepName = stepExecution.getStepName();
    }
}

