/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.pepstock.jem.springbatch.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLParser {
    private XMLReader xmlReader = XMLReaderFactory.createXMLReader();
    private StringReader reader;
    private String jobName = null;

    public XMLParser(StringReader reader) throws SAXException {
        this.xmlReader.setContentHandler(new MessageHandler());
        this.reader = reader;
    }

    public String parse() throws SAXException, IOException {
        if (this.reader != null) {
            this.xmlReader.parse(new InputSource(this.reader));
        }
        return this.jobName;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private class MessageHandler
    extends DefaultHandler {
        @Override
        public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            try {
                String abstr;
                if (localName.equalsIgnoreCase("job") && (abstr = Utils.getOptional(attributes, "abstract")) == null) {
                    String findjobName = Utils.getMandatory(attributes, "id");
                    XMLParser.this.jobName = findjobName;
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new SAXException(uee);
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        }
    }
}

