/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Utils {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String ENCODING_DEFAULT = "UTF-8";

    public static String encode(String s) throws UnsupportedEncodingException {
        return Utils.encode(s, "UTF-8");
    }

    public static String encode(String s, String charEncoding) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, charEncoding);
    }

    public static String decode(String s) throws UnsupportedEncodingException {
        return Utils.decode(s, "UTF-8");
    }

    public static String decode(String s, String charEncoding) throws UnsupportedEncodingException {
        return s == null ? null : URLDecoder.decode(s, charEncoding);
    }

    public static String getMandatory(Attributes attrs, String attribute) throws SAXException, UnsupportedEncodingException {
        return Utils.getMandatory(attrs, attribute, "UTF-8");
    }

    public static String getMandatory(Attributes attrs, String attribute, String charEncoding) throws SAXException, UnsupportedEncodingException {
        String value = attrs.getValue(attribute);
        if (value == null) {
            value = attrs.getValue(attribute.toUpperCase());
        }
        if (value == null) {
            value = attrs.getValue(attribute.toLowerCase());
        }
        if (value == null) {
            throw new SAXException("Attribute '" + attribute + "' is missing");
        }
        return Utils.decode(value, charEncoding);
    }

    public static String getOptional(Attributes attrs, String attribute, String defaultValue) throws UnsupportedEncodingException {
        return Utils.getOptional(attrs, attribute, defaultValue, "UTF-8");
    }

    public static String getOptional(Attributes attrs, String attribute, String defaultValue, String charEncoding) throws UnsupportedEncodingException {
        String value = attrs.getValue(attribute);
        if (value == null) {
            value = attrs.getValue(attribute.toUpperCase());
        }
        if (value == null) {
            value = attrs.getValue(attribute.toLowerCase());
        }
        return value == null ? defaultValue : Utils.decode(value, charEncoding);
    }

    public static String getOptional(Attributes attrs, String attribute) throws UnsupportedEncodingException {
        return Utils.getOptional(attrs, attribute, null);
    }
}

