/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.tasks.DefaultJobTask;
import org.pepstock.jem.node.tasks.JavaUtils;
import org.pepstock.jem.node.tasks.shell.JavaCommand;
import org.pepstock.jem.springbatch.SpringBatchJcl;
import org.pepstock.jem.springbatch.SpringBatchLauncher;

public class SpringBatchTask
extends DefaultJobTask {
    private static final long serialVersionUID = 1L;
    private static final String[] FOLDER = new String[]{"spring", "springbatch"};

    public SpringBatchTask(Job job, JemFactory factory) {
        super(job, factory);
    }

    @Override
    public void configure() throws Exception {
        super.configure();
        String currentClassPath = JavaUtils.getClassPath(FOLDER);
        Job job = this.getJob();
        File jclFile = Main.OUTPUT_SYSTEM.getJclFile(job);
        currentClassPath = currentClassPath + File.pathSeparator + FilenameUtils.normalize((String)jclFile.getParentFile().getAbsolutePath(), (boolean)true);
        this.getEnv().put("CLASSPATH", currentClassPath);
        SpringBatchJcl jcl = (SpringBatchJcl)job.getJcl();
        if (jcl.getClassPath() != null) {
            currentClassPath = currentClassPath + File.pathSeparator + jcl.getClassPath();
            this.getEnv().put("CLASSPATH", currentClassPath);
        }
        JavaCommand jCommand = this.getCommand();
        jCommand.setClassPath(currentClassPath);
        jCommand.setClassName(SpringBatchLauncher.class.getName());
        jCommand.setClassArguments(jclFile.getName(), jcl.getOptions() != null ? jcl.getOptions() : "", job.getName(), jcl.getParameters() != null ? jcl.getParameters() : "");
    }
}

