/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.springbatch;

import java.io.StringReader;
import javax.xml.bind.ValidationException;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.factories.AbstractFactory;
import org.pepstock.jem.factories.JclFactoryException;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.tasks.JobTask;
import org.pepstock.jem.springbatch.JemBean;
import org.pepstock.jem.springbatch.SpringBatchJcl;
import org.pepstock.jem.springbatch.SpringBatchMessage;
import org.pepstock.jem.springbatch.SpringBatchTask;
import org.pepstock.jem.springbatch.XMLParser;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class SpringBatchFactory
extends AbstractFactory {
    private static final long serialVersionUID = 1L;
    private static final String SPRINGBATCH_TYPE = "sb";
    private static final String SPRINGBATCH_TYPE_DESCRIPTION = "Spring Batch";

    @Override
    public Jcl createJcl(String content) throws JclFactoryException {
        SpringBatchJcl jcl = new SpringBatchJcl();
        jcl.setType(SPRINGBATCH_TYPE);
        jcl.setContent(content);
        try {
            this.validate(jcl);
        }
        catch (Exception e) {
            JclFactoryException jfe = new JclFactoryException(e);
            jfe.setJcl(jcl);
            throw jfe;
        }
        return jcl;
    }

    private void validate(SpringBatchJcl jcl) throws Exception {
        String user;
        String emailAddresses;
        JemBean bean = null;
        ByteArrayResource res = new ByteArrayResource(jcl.getContent().getBytes());
        XmlBeanFactory factory = new XmlBeanFactory((Resource)res);
        Object object = factory.getBean("jem.bean");
        if (object == null) {
            throw new Exception(SpringBatchMessage.JEMS005E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (!(object instanceof JemBean)) {
            throw new Exception(SpringBatchMessage.JEMS005E.toMessage().getFormattedMessage(object.getClass().getName()));
        }
        bean = (JemBean)object;
        XMLParser parser = new XMLParser(new StringReader(jcl.getContent()));
        String jobName = parser.parse();
        parser.close();
        bean.setJobName(jobName);
        if (bean.getJobName() == null) {
            throw new ValidationException(SpringBatchMessage.JEMS020E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (bean.getEnvironment() == null) {
            bean.setEnvironment(Main.EXECUTION_ENVIRONMENT.getEnvironment());
        }
        if (bean.getDomain() == null) {
            bean.setDomain("***");
        }
        if (null != (emailAddresses = bean.getEmailsNotification())) {
            jcl.setEmailNotificationAddresses(emailAddresses);
        }
        if (null != (user = bean.getUser())) {
            jcl.setUser(user);
        }
        if (bean.getAffinity() == null) {
            bean.setAffinity("***");
        }
        if (bean.getClassPath() != null) {
            String classPath = bean.getClassPath();
            bean.setClassPath(super.resolvePathNames(classPath, "jem.classpath"));
        }
        jcl.setJobName(bean.getJobName());
        jcl.setEnvironment(bean.getEnvironment());
        jcl.setDomain(bean.getDomain());
        jcl.setAffinity(bean.getAffinity());
        jcl.setHold(bean.isHold());
        jcl.setPriority(bean.getPriority());
        jcl.setMemory(bean.getMemory());
        jcl.setClassPath(bean.getClassPath());
        if (bean.getOptions() != null) {
            jcl.setOptions(bean.getOptions());
        }
        if (bean.getParameters() != null) {
            jcl.setParameters(bean.getParameters());
        }
    }

    @Override
    public JobTask createJobTask(Job job) {
        return new SpringBatchTask(job, this);
    }

    @Override
    public String getType() {
        return SPRINGBATCH_TYPE;
    }

    @Override
    public String getTypeDescription() {
        return SPRINGBATCH_TYPE_DESCRIPTION;
    }
}

