/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.quartz;

import java.util.ArrayList;
import org.pepstock.jem.commands.Submit;
import org.pepstock.jem.commands.SubmitResult;
import org.pepstock.jem.node.NodeMessage;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobSubmit
implements Job {
    private String jclUrl = null;
    private String jclType = null;
    private String password = null;
    private String hostForJemWeb = null;
    private String privateKeyFile = null;
    private String privateKeyPwd = null;
    private boolean noWait = false;

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        SubmitResult sr = Submit.executeCommand(this.createArgs());
        if (sr.getRc() != 0) {
            throw new JobExecutionException(NodeMessage.JEMC021I.toMessage().getFormattedMessage("", sr.getRc()));
        }
    }

    private String[] createArgs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.jclUrl != null) {
            list.add("-jcl");
            list.add(this.jclUrl);
        }
        if (this.jclType != null) {
            list.add("-type");
            list.add(this.jclType);
        }
        if (this.password != null) {
            list.add("-password");
            list.add(this.password);
        }
        if (this.hostForJemWeb != null) {
            list.add("-host");
            list.add(this.hostForJemWeb);
        }
        if (this.privateKeyFile != null) {
            list.add("-privateKey");
            list.add(this.privateKeyFile);
        }
        if (this.privateKeyPwd != null) {
            list.add("-privateKeyPwd");
            list.add(this.privateKeyPwd);
        }
        if (this.noWait) {
            list.add("-nowait");
        }
        return list.toArray(new String[list.size()]);
    }

    public void setJclUrl(String jclUrl) {
        this.jclUrl = jclUrl;
    }

    public void setJclType(String jclType) {
        this.jclType = jclType;
    }

    public void setHostForJemWeb(String hostForJemWeb) {
        this.hostForJemWeb = hostForJemWeb;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public void setPrivateKeyPwd(String privateKeyPwd) {
        this.privateKeyPwd = privateKeyPwd;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

