/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.quartz;

import java.util.ArrayList;
import org.pepstock.jem.commands.LocalHostSubmit;
import org.pepstock.jem.commands.SubmitResult;
import org.pepstock.jem.node.NodeMessage;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobLocalHostSubmit
implements Job {
    private String jemEnv = null;
    private String password = null;
    private String jemPort = null;
    private String jclUrl = null;
    private String jclType = null;
    private boolean noWait = false;
    private String privateKeyFile = null;
    private String privateKeyPwd = null;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        SubmitResult sr = LocalHostSubmit.executeCommand(this.createArgs());
        if (sr.getRc() != 0) {
            throw new JobExecutionException(NodeMessage.JEMC021I.toMessage().getFormattedMessage("", sr.getRc()));
        }
    }

    private String[] createArgs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.jemEnv != null) {
            list.add("-env");
            list.add(this.jemEnv);
        }
        if (this.password != null) {
            list.add("-password");
            list.add(this.password);
        }
        if (this.jemPort != null) {
            list.add("-port");
            list.add(this.jemPort);
        }
        if (this.jclUrl != null) {
            list.add("-jcl");
            list.add(this.jclUrl);
        }
        if (this.jclType != null) {
            list.add("-type");
            list.add(this.jclType);
        }
        if (this.privateKeyFile != null) {
            list.add("-privateKey");
            list.add(this.privateKeyFile);
        }
        if (this.privateKeyPwd != null) {
            list.add("-privateKeyPwd");
            list.add(this.privateKeyPwd);
        }
        if (this.noWait) {
            list.add("-nowait");
        }
        return list.toArray(new String[list.size()]);
    }

    public void setJemEnv(String jemEnv) {
        this.jemEnv = jemEnv;
    }

    public void setJemPort(String jemPort) {
        this.jemPort = jemPort;
    }

    public void setJclUrl(String jclUrl) {
        this.jclUrl = jclUrl;
    }

    public void setJclType(String jclType) {
        this.jclType = jclType;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public void setPrivateKeyPwd(String privateKeyPwd) {
        this.privateKeyPwd = privateKeyPwd;
    }
}

