/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.notify.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.mail.internet.AddressException;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.notify.JemEmail;
import org.pepstock.jem.notify.JemInternetAddress;
import org.pepstock.jem.notify.NotifyMessage;
import org.pepstock.jem.notify.exception.FactoryException;
import org.pepstock.jem.util.VariableSubstituter;

public class Factory {
    public static JemEmail createEmail(JemEmail emailTemplate, String[] toEmailAddresses, Properties properties) throws FactoryException {
        JemEmail resultMail = new JemEmail();
        if (emailTemplate.hasFormat()) {
            resultMail.setFormat(emailTemplate.getFormat());
        }
        resultMail.addToEmailAddresses(Factory.createToEmailAddresses(toEmailAddresses));
        if (emailTemplate.hasFromUserEmailAddress()) {
            resultMail.setFromUserEmailAddress(emailTemplate.getFromUserEmailAddress());
        }
        if (emailTemplate.hasFromUserName()) {
            resultMail.setFromUserName(emailTemplate.getFromUserName());
        }
        if (emailTemplate.hasSubject()) {
            String subject = Factory.createEmailSubject(emailTemplate, properties);
            resultMail.setSubject(subject);
        }
        if (emailTemplate.hasText()) {
            String text = Factory.createEmailText(emailTemplate, properties);
            resultMail.setText(text);
        }
        return resultMail;
    }

    public static List<JemInternetAddress> createToEmailAddresses(Collection<String> toEmailAddresses) throws FactoryException {
        String[] addressesTo = toEmailAddresses.toArray(new String[toEmailAddresses.size()]);
        return Factory.createToEmailAddresses(addressesTo);
    }

    public static List<JemInternetAddress> createToEmailAddresses(String[] toEmailAddresses) throws FactoryException {
        ArrayList<JemInternetAddress> toEAddresses = new ArrayList<JemInternetAddress>();
        if (null != toEmailAddresses) {
            for (int i = 0; i < toEmailAddresses.length; ++i) {
                try {
                    JemInternetAddress address = new JemInternetAddress(toEmailAddresses[i].trim());
                    toEAddresses.add(address);
                    continue;
                }
                catch (AddressException aEx) {
                    LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN001E, aEx, toEmailAddresses[i].trim());
                }
            }
            if (toEAddresses.size() == 0) {
                LogAppl.getInstance().emit(NotifyMessage.JEMN002E);
                throw new FactoryException(NotifyMessage.JEMN002E.toMessage().getMessage());
            }
            return toEAddresses;
        }
        LogAppl.getInstance().emit(NotifyMessage.JEMN003E);
        throw new FactoryException(NotifyMessage.JEMN003E.toMessage().getMessage());
    }

    public static String createEmailText(JemEmail emailTemplate, Properties properties) throws FactoryException {
        String textTemplate = emailTemplate.getText();
        return VariableSubstituter.substitute(textTemplate, properties);
    }

    public static String createEmailSubject(JemEmail emailTemplate, Properties properties) throws FactoryException {
        String subjectTemplate = emailTemplate.getSubject();
        return VariableSubstituter.substitute(subjectTemplate, properties);
    }
}

