/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.notify.engine;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.notify.JemEmail;
import org.pepstock.jem.notify.NotifyMessage;
import org.pepstock.jem.notify.exception.EmailConfigurationException;

public class EmailTemplateReader
extends FileAlterationListenerAdaptor {
    private static final long CHECK_INTERVAL = 60000L;
    private static final String EMAIL_TEMPLATE_ROOT_TAG = "email-template";
    private static final Class<JemEmail> EMAIL_TEMPLATE_ROOT_ALIAS = JemEmail.class;
    private File emailTemplateFile;
    private FileAlterationObserver emailTemplateFileObserver;
    private JemEmail emailTemplate;
    private XStream xstream;
    private boolean automaticControlStarted = false;

    public EmailTemplateReader(String emailTemplateFile) throws EmailConfigurationException {
        this.emailTemplateFile = new File(emailTemplateFile);
        if (null == this.emailTemplateFile.getParentFile() || !this.emailTemplateFile.getParentFile().exists() || !this.emailTemplateFile.getParentFile().isDirectory() || this.emailTemplateFile.getParentFile().toString().equalsIgnoreCase(File.separator)) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN006E, this.emailTemplateFile.getParentFile());
            throw new EmailConfigurationException(NotifyMessage.JEMN006E.toMessage().getFormattedMessage(this.emailTemplateFile.getParentFile()));
        }
        if (!this.emailTemplateFile.exists()) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN007W, this.emailTemplateFile, this.emailTemplateFile.getParentFile());
        }
    }

    public void initialize() {
        this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.xstream.alias(EMAIL_TEMPLATE_ROOT_TAG, EMAIL_TEMPLATE_ROOT_ALIAS);
        FieldAlias[] aliases = FieldAlias.values();
        for (int i = 0; i < aliases.length; ++i) {
            this.xstream.aliasField(aliases[i].getAliasXmlTag(), JemEmail.class, aliases[i].getFieldName());
        }
        this.emailTemplateFileObserver = new FileAlterationObserver(this.emailTemplateFile.getParentFile());
        this.emailTemplateFileObserver.addListener((FileAlterationListener)this);
        FileAlterationMonitor fileMonitor = new FileAlterationMonitor(60000L);
        fileMonitor.addObserver(this.emailTemplateFileObserver);
        try {
            this.readEmailTemplate();
        }
        catch (EmailConfigurationException ex) {
            LogAppl.getInstance().emit(NotifyMessage.JEMN008E);
        }
        try {
            fileMonitor.start();
            this.automaticControlStarted = true;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN009E, ex, this.emailTemplateFile);
        }
    }

    public JemEmail getEmailTemplate() throws EmailConfigurationException {
        if (!this.automaticControlStarted) {
            this.readEmailTemplate();
        }
        if (null == this.emailTemplate) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN010E, this.emailTemplateFile);
            throw new EmailConfigurationException(NotifyMessage.JEMN010E.toMessage().getFormattedMessage(this.emailTemplateFile));
        }
        return this.emailTemplate;
    }

    private void readEmailTemplate() throws EmailConfigurationException {
        try {
            FileInputStream fis = new FileInputStream(this.emailTemplateFile);
            JemEmail emailTemplate = (JemEmail)this.xstream.fromXML((InputStream)fis);
            fis.close();
            this.emailTemplate = emailTemplate;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN010E, ex, this.emailTemplateFile);
            throw new EmailConfigurationException(NotifyMessage.JEMN010E.toMessage().getFormattedMessage(this.emailTemplateFile), ex);
        }
        if (null != this.emailTemplate && !this.emailTemplate.hasFromUserEmailAddress()) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, FieldAlias.FROM_USER_EMAIL_ADDRESS_ALIAS.getFieldName());
            throw new EmailConfigurationException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage(FieldAlias.FROM_USER_EMAIL_ADDRESS_ALIAS.getFieldName()));
        }
    }

    public void onFileChange(File file) {
        if (file.equals(this.emailTemplateFile)) {
            try {
                this.readEmailTemplate();
            }
            catch (EmailConfigurationException ex) {
                LogAppl.getInstance().emit(NotifyMessage.JEMN008E);
            }
        }
    }

    public void onFileCreate(File file) {
        if (file.equals(this.emailTemplateFile)) {
            try {
                this.readEmailTemplate();
            }
            catch (EmailConfigurationException ex) {
                LogAppl.getInstance().emit(NotifyMessage.JEMN008E);
            }
        }
    }

    public void onFileDelete(File file) {
        if (file.equals(this.emailTemplateFile)) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN011W, this.emailTemplateFile, this.emailTemplateFile.getParentFile());
        }
    }

    private static enum FieldAlias {
        FROM_USER_NAME_ALIAS("from-user-name", "fromUserName"),
        FROM_USER_EMAIL_ADDRESS_ALIAS("from-user-email-address", "fromUserEmailAddress");

        private String aliasXmlTag;
        private String fieldName;

        private FieldAlias(String aliasXmlTag, String fieldName) {
            this.aliasXmlTag = aliasXmlTag;
            this.fieldName = fieldName;
        }

        public String getAliasXmlTag() {
            return this.aliasXmlTag;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

