/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.notify.engine;

import java.util.Date;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.notify.EmailFormat;
import org.pepstock.jem.notify.JemEmail;
import org.pepstock.jem.notify.NotifyMessage;
import org.pepstock.jem.notify.NotifyObject;
import org.pepstock.jem.notify.engine.NotifierInterface;
import org.pepstock.jem.notify.exception.EmailConfigurationException;
import org.pepstock.jem.notify.exception.NotifyException;
import org.pepstock.jem.notify.exception.SendMailException;

public class EmailNotifier
implements NotifierInterface {
    protected static final int NO_SMTP_PORT = -1;
    protected static final boolean DEFAULT_IS_SSL = false;
    protected static final boolean DEFAULT_IS_TLS = false;
    private String emailServer = null;
    private int smtpPort = -1;
    private String bounceAddress = null;
    private boolean isSSL = false;
    private boolean isTLS = false;
    private String authenticationUserId = null;
    private String authenticationPassword = null;

    public void init(String emailServer, String bounceAddress, boolean isSSL, boolean isTLS, int smtpPort, String authenticationUserId, String authenticationPassword) throws EmailConfigurationException {
        if (null == emailServer) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, "Email Server");
            throw new EmailConfigurationException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage("Email Server"));
        }
        if (isTLS && (authenticationPassword == null || authenticationUserId == null)) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, "SMTP server authentication userid or password with TLS protocol");
            throw new EmailConfigurationException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage("SMTP server authentication userid or password with TLS protocol"));
        }
        if (isSSL && (authenticationPassword == null || authenticationUserId == null)) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, "SMTP server authentication userid or password with SSL protocol");
            throw new EmailConfigurationException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage("SMTP server authentication userid or password with SSL protocol"));
        }
        if (null != authenticationUserId && null == authenticationPassword) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, "SMTP server authentication password with authentication userid");
            throw new EmailConfigurationException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage("SMTP server authentication password with authentication userid"));
        }
        if (null == authenticationUserId && null != authenticationPassword) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, "SMTP server authentication userid with authentication password");
            throw new EmailConfigurationException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage("SMTP server authentication userid with authentication password"));
        }
        this.emailServer = emailServer;
        if (null != bounceAddress) {
            this.bounceAddress = bounceAddress;
        }
        this.isSSL = isSSL;
        this.isTLS = isTLS;
        this.smtpPort = smtpPort;
        if (null != authenticationUserId) {
            this.authenticationUserId = authenticationUserId;
        }
        if (null != authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
        }
    }

    public void init(String emailServer, String bounceAddress, boolean isSSL, boolean isTLS, int smtpPort) throws EmailConfigurationException {
        this.init(emailServer, bounceAddress, isSSL, isTLS, smtpPort, null, null);
    }

    public void init(String emailServer, String bounceAddress) throws EmailConfigurationException {
        this.init(emailServer, bounceAddress, false, false, -1);
    }

    public void init(String emailServer) throws EmailConfigurationException {
        this.init(emailServer, null);
    }

    public String getBounceAddress() {
        return this.bounceAddress;
    }

    public void setBounceAddress(String bounceAddress) {
        this.bounceAddress = bounceAddress;
    }

    public void setIsSSL(boolean isSSL) {
        this.isSSL = isSSL;
    }

    public void setIsTLS(boolean isTLS) {
        this.isTLS = isTLS;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getEmailServer() {
        return this.emailServer;
    }

    public void setEmailServer(String emailServer) {
        this.emailServer = emailServer;
    }

    @Override
    public void doNotify(NotifyObject notifyObject) throws NotifyException {
        this.doMailNotify((JemEmail)notifyObject);
    }

    private void doMailNotify(JemEmail email) throws SendMailException {
        if (null == email) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN013E, "Email to send");
            throw new SendMailException(NotifyMessage.JEMN013E.toMessage().getFormattedMessage("Email to send"));
        }
        if (!email.hasToEmailAddresses()) {
            LogAppl.getInstance().emit(NotifyMessage.JEMN003E);
            throw new SendMailException(NotifyMessage.JEMN003E.toMessage().getMessage());
        }
        if (!email.hasFromUserEmailAddress()) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, "From User Email Address");
            throw new SendMailException(NotifyMessage.JEMN012E.toMessage().getFormattedMessage("From User Email Address"));
        }
        Object sendingEmail = null;
        sendingEmail = email.getFormat() == EmailFormat.TEXT_HTML ? new HtmlEmail() : new SimpleEmail();
        this.sendEmail(email, (Email)sendingEmail);
    }

    private void sendEmail(JemEmail email, Email sendingEmail) throws SendMailException {
        try {
            sendingEmail.setHostName(this.emailServer);
            if (this.smtpPort != -1) {
                sendingEmail.setSmtpPort(this.smtpPort);
            }
            sendingEmail.setFrom(email.getFromUserEmailAddress(), email.getFromUserName());
            if (email.hasSubject()) {
                sendingEmail.setSubject(email.getSubject());
            } else {
                LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN014W, "Subject");
            }
            if (email.hasText()) {
                sendingEmail.setMsg(email.getText());
            } else {
                LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN014W, "Text Message");
            }
            sendingEmail.setTo(email.getAllToEmailAddresses());
            if (null != this.bounceAddress) {
                sendingEmail.setBounceAddress(this.bounceAddress);
            }
            sendingEmail.setSentDate(new Date());
            sendingEmail.setSSL(this.isSSL);
            sendingEmail.setTLS(this.isTLS);
            if (null != this.authenticationUserId && null != this.authenticationPassword) {
                sendingEmail.setAuthenticator((Authenticator)new DefaultAuthenticator(this.authenticationUserId, this.authenticationPassword));
            }
            sendingEmail.send();
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN015I, email);
        }
        catch (EmailException eEx) {
            LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN016E, eEx, email);
            throw new SendMailException(NotifyMessage.JEMN016E.toMessage().getFormattedMessage(email), (Exception)((Object)eEx));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("EmailNotifier: \n");
        buffer.append("\tEmail Server = " + this.emailServer + "\n");
        buffer.append("\tSMTP Port = " + this.smtpPort + "\n");
        buffer.append("\tIs SSL = " + this.isSSL + "\n");
        buffer.append("\tIs TLS = " + this.isTLS + "\n");
        buffer.append("\tBounce Address = " + this.bounceAddress + "\n");
        if (null != this.authenticationUserId && null != this.authenticationPassword) {
            buffer.append("\tSMTP Authorization needed = true.");
        } else {
            buffer.append("\tSMTP Authorization needed = false.");
        }
        return buffer.toString();
    }
}

