/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.shell;

import java.util.LinkedList;
import java.util.List;
import org.pepstock.jem.node.tasks.shell.Command;

public class JavaCommand
extends Command {
    private static final String JAVA_COMMAND_NAME = "java";
    private List<String> javaOptions = new LinkedList<String>();
    private String className = null;
    private String classPath = null;
    private List<String> classArguments = new LinkedList<String>();

    public JavaCommand() {
        super(JAVA_COMMAND_NAME);
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public List<String> getJavaOptions() {
        return this.javaOptions;
    }

    public void setJavaOptions(List<String> javaOptions) {
        this.javaOptions = javaOptions;
    }

    public void setJavaOptions(String ... commands) {
        for (String element : commands) {
            this.javaOptions.add(element);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<String> getClassArguments() {
        return this.classArguments;
    }

    public void setClassArguments(List<String> classArguments) {
        this.classArguments = classArguments;
    }

    public void setClassArguments(String ... commands) {
        for (String element : commands) {
            this.classArguments.add(element);
        }
    }

    @Override
    public StringBuffer toCommandLine() {
        if (this.className == null) {
            throw new NullPointerException("Classname is null");
        }
        StringBuffer sb = super.toCommandLine();
        for (String token : this.javaOptions) {
            sb.append(token).append(" ");
        }
        sb.append(this.className).append(" ");
        for (String token : this.classArguments) {
            sb.append(token).append(" ");
        }
        return sb;
    }

    @Override
    public LinkedList<String> toCommandLineList() {
        LinkedList<String> commandList = super.toCommandLineList();
        for (String token : this.javaOptions) {
            commandList.add(token);
        }
        commandList.add(this.className);
        for (String token : this.classArguments) {
            commandList.add(token);
        }
        return commandList;
    }

    @Override
    public String toString() {
        return "JavaCommand [" + this.toCommandLine() + "]";
    }
}

