/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.tasks.platform.AbstractPlatform;
import org.pepstock.jem.node.tasks.shell.JavaCommand;
import org.pepstock.jem.node.tasks.shell.Shell;

public class UnixPlatform
extends AbstractPlatform {
    public static final String JOB_FILE_SHELL = "job.sh";
    public static final String DEFAULT_UNIX_SHELL_NAME = "bash";
    public static final String DEFAULT_UNIX_SHELL_PARAMETERS = "-c";
    private final Shell SHELL = new Shell("bash", "-c");

    @Override
    public Shell getShell() {
        return this.SHELL;
    }

    @Override
    public String getCommand(Job job, JavaCommand command, boolean sudo) throws Exception {
        String commandToExecute = null;
        command.setJavaOptions("-cp $CLASSPATH");
        File logFile = Main.OUTPUT_SYSTEM.getMessagesLogFile(job);
        String redirect = "> " + FilenameUtils.normalize((String)logFile.getAbsolutePath(), (boolean)true) + " 2>&1";
        if (sudo) {
            File outputFolder = Main.OUTPUT_SYSTEM.getOutputPath(job);
            File scriptFile = new File(outputFolder, JOB_FILE_SHELL);
            this.write(scriptFile, job, command);
            commandToExecute = scriptFile.getAbsolutePath() + " " + redirect;
        } else {
            commandToExecute = command.toCommandLine() + " " + redirect;
        }
        return commandToExecute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean kill(long pid, String user, boolean force, boolean sudo) {
        boolean isCancelled = true;
        Process p = null;
        try {
            ArrayList<Long> processes = this.getProcessesChain(pid);
            String processesString = String.valueOf(pid);
            for (Long process : processes) {
                if (process == pid) continue;
                processesString = String.valueOf(process) + " " + processesString;
            }
            p = sudo ? (force ? Runtime.getRuntime().exec("sudo -n -u " + user + " -i kill -9 " + processesString) : Runtime.getRuntime().exec("sudo -n -u " + user + " -i kill " + processesString)) : (force ? Runtime.getRuntime().exec("kill -9 " + processesString) : Runtime.getRuntime().exec("kill " + processesString));
            int rc = p.waitFor();
            if (rc != 0) {
                isCancelled = false;
            }
        }
        catch (IOException e) {
            isCancelled = false;
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC017E, e);
        }
        catch (InterruptedException e) {
            isCancelled = false;
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC017E, e);
        }
        catch (Exception e) {
            isCancelled = false;
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC017E, e);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return isCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File file, Job job, JavaCommand jCommand) throws IOException {
        String user = job.isUserSurrogated() ? job.getJcl().getUser() : job.getUser();
        PrintStream fos = null;
        try {
            fos = new PrintStream(new FileOutputStream(file));
            if (jCommand.getClassPath() != null) {
                String pathSeparator = File.pathSeparator;
                String classPathProperty = jCommand.getClassPath();
                String[] filesNames = classPathProperty.split(pathSeparator);
                for (int i = 0; i < filesNames.length; ++i) {
                    if (i == 0) {
                        fos.println("CLASSPATH=" + filesNames[i]);
                        continue;
                    }
                    fos.println("CLASSPATH=$CLASSPATH:" + filesNames[i]);
                }
            }
            fos.println("sudo -n -u " + user + " -i " + jCommand.toCommandLine());
            fos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        file.setExecutable(true, false);
    }
}

