/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.platform;

import java.util.ArrayList;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.pepstock.jem.node.tasks.platform.Platform;

public abstract class AbstractPlatform
implements Platform {
    public ArrayList<Long> getProcessesChain(long pid) {
        Sigar sigar = new Sigar();
        ArrayList<Long> processes = new ArrayList<Long>();
        processes.add(pid);
        try {
            long[] allProcessesId = sigar.getProcList();
            this.loadChildProcessId(pid, allProcessesId, processes, sigar);
        }
        catch (SigarException e) {
            // empty catch block
        }
        return processes;
    }

    private void loadChildProcessId(long parentId, long[] allProcessesId, ArrayList<Long> processes, Sigar sigar) {
        for (long processId : allProcessesId) {
            try {
                ProcState state = sigar.getProcState(processId);
                if (state.getPpid() != parentId) continue;
                processes.add(processId);
                this.loadChildProcessId(processId, allProcessesId, processes, sigar);
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
    }
}

