/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.lang3.StringUtils;
import org.jppf.utils.TypedProperties;
import org.pepstock.jem.jppf.JPPFMessage;

public class JppfFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        String addresses = null;
        Reference ref = (Reference)obj;
        RefAddr ra = ref.get("addresses");
        if (ra == null) {
            throw new Exception(JPPFMessage.JEMJ009E.toMessage().getFormattedMessage("addresses"));
        }
        addresses = ra.getContent().toString().trim();
        return JppfFactory.createTypeProperties(addresses);
    }

    public static Object createTypeProperties(String address) throws Exception {
        String[] addresses;
        TypedProperties props = new TypedProperties();
        props.setProperty("jppf.discovery.enabled", Boolean.FALSE.toString());
        if (address != null && (addresses = StringUtils.split((String)(address = StringUtils.remove((String)address, (String)" ")), (String)",")) != null && addresses.length > 0) {
            StringBuffer drivers = new StringBuffer();
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].contains(":")) {
                    throw new Exception(JPPFMessage.JEMJ008E.toMessage().getFormattedMessage(addresses[i]));
                }
                String host = StringUtils.substringBefore((String)addresses[i], (String)":");
                String port = StringUtils.substringAfter((String)addresses[i], (String)":");
                String driver = "jem" + i;
                props.setProperty(driver + ".jppf.server.port", port);
                props.setProperty(driver + ".jppf.server.host", host);
                drivers.append(driver).append(" ");
            }
            props.setProperty("jppf.drivers", drivers.toString());
        }
        return props;
    }
}

