/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.jndi;

import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.pepstock.jem.node.NodeMessage;

public class JmsFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        this.addJmsEnvironmentParams(ref, nameCtx);
        String connectionFactoryName = this.getReferencePropertyValue(ref, "connectionFactoryName", true);
        ConnectionFactory connectionFactory = (ConnectionFactory)nameCtx.lookup(connectionFactoryName);
        return connectionFactory;
    }

    private void addJmsEnvironmentParams(Reference reference, Context nameCtx) throws Exception {
        String providerUrl = this.getReferencePropertyValue(reference, "java.naming.provider.url", true);
        nameCtx.addToEnvironment("java.naming.provider.url", providerUrl);
        String initialContextFactor = this.getReferencePropertyValue(reference, "java.naming.factory.initial", true);
        nameCtx.addToEnvironment("java.naming.factory.initial", initialContextFactor);
        String principal = this.getReferencePropertyValue(reference, "username", false);
        String credentials = this.getReferencePropertyValue(reference, "password", false);
        if (null != principal && null != credentials) {
            nameCtx.addToEnvironment("java.naming.security.principal", principal);
            nameCtx.addToEnvironment("java.naming.security.credentials", credentials);
        }
    }

    private String getReferencePropertyValue(Reference reference, String propertyName, boolean mandatory) throws Exception {
        RefAddr ra = reference.get(propertyName);
        if (null == ra || null == ra.getContent() || ra.getContent().toString().trim().equalsIgnoreCase("")) {
            if (mandatory) {
                throw new Exception(NodeMessage.JEMC136E.toMessage().getFormattedMessage(propertyName));
            }
            return null;
        }
        return ra.getContent().toString();
    }
}

