/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.jndi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.pepstock.jem.jppf.DataStreamNameClassPair;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.tasks.jndi.AbsoluteHashMap;
import org.pepstock.jem.node.tasks.jndi.DataStreamReference;

public class JemContext
extends InitialContext
implements Context {
    private Map<String, Object> bindings = AbsoluteHashMap.getInstance();
    private Hashtable env = new Hashtable();

    public JemContext(Hashtable env) throws NamingException {
        super(true);
        if (env != null) {
            this.env = env;
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException(NodeMessage.JEMC139E.toMessage().getMessage());
        }
        String atom = name.get(0);
        Object inter = this.bindings.get(atom);
        if (name.size() == 1) {
            if (inter != null) {
                throw new NameAlreadyBoundException(NodeMessage.JEMC102E.toMessage().getMessage());
            }
            obj = NamingManager.getStateToBind(obj, new CompositeName().add(atom), this, this.env);
            this.bindings.put(atom, obj);
        }
        throw new NamingException(NodeMessage.JEMC101E.toMessage().getFormattedMessage(atom));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException(NodeMessage.JEMC139E.toMessage().getMessage());
        }
        String atom = name.get(0);
        Object inter = this.bindings.get(atom);
        if (name.size() == 1) {
            if (inter == null) {
                throw new NameNotFoundException(NodeMessage.JEMC100E.toMessage().getFormattedMessage(name));
            }
            try {
                return NamingManager.getObjectInstance(inter, new CompositeName().add(atom), this, this.env);
            }
            catch (Exception e) {
                NamingException ne = new NamingException(NodeMessage.JEMC140E.toMessage().getMessage());
                ne.setRootCause(e);
                throw ne;
            }
        }
        throw new NamingException(NodeMessage.JEMC101E.toMessage().getFormattedMessage(atom));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException(NodeMessage.JEMC139E.toMessage().getMessage());
        }
        String atom = name.get(0);
        if (name.size() == 1) {
            obj = NamingManager.getStateToBind(obj, new CompositeName().add(atom), this, this.env);
            this.bindings.put(atom, obj);
            return;
        }
        throw new NamingException(NodeMessage.JEMC101E.toMessage().getFormattedMessage(atom));
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(NodeMessage.JEMC139E.toMessage().getMessage());
        }
        String atom = name.get(0);
        if (name.size() == 1) {
            this.bindings.remove(atom);
            return;
        }
        throw new NamingException(NodeMessage.JEMC101E.toMessage().getFormattedMessage(atom));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        ArrayList<NameClassPair> items = new ArrayList<NameClassPair>();
        for (String key : this.bindings.keySet()) {
            NameClassPair pair;
            if (!name.equalsIgnoreCase("") && !key.startsWith(name)) continue;
            Object value = this.bindings.get(key);
            if (value instanceof DataStreamReference) {
                pair = new DataStreamNameClassPair(key, value.getClass().getName(), false);
                ((DataStreamNameClassPair)pair).setObject(value);
                items.add(pair);
                continue;
            }
            if (value.getClass().getName().equalsIgnoreCase(DataStreamReference.class.getName())) {
                pair = new DataStreamNameClassPair(key, value.getClass().getName(), false);
                ((DataStreamNameClassPair)pair).setObject(value);
                items.add(pair);
                continue;
            }
            pair = new NameClassPair(key, value.getClass().getName(), false);
            items.add(pair);
        }
        return new JemNamingEnumeration(items.iterator());
    }

    static class JemNamingEnumeration
    implements NamingEnumeration<NameClassPair> {
        private Iterator<NameClassPair> iter = null;

        public JemNamingEnumeration(Iterator<NameClassPair> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public NameClassPair nextElement() {
            return this.iter.next();
        }

        @Override
        public NameClassPair next() throws NamingException {
            return this.iter.next();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.iter.hasNext();
        }

        @Override
        public void close() throws NamingException {
        }
    }
}

