/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.jndi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.message.BasicNameValuePair;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.HttpResource;
import org.pepstock.jem.util.Parser;

public class HttpFactory
implements ObjectFactory {
    public static final int DEFAULT_HTTPS_PORT = 443;

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        Properties properties = new Properties();
        for (String propertyName : HttpResource.PROPERTIES_ALL) {
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString().trim();
            properties.setProperty(propertyName, propertyValue);
        }
        HttpClient httpClient = (HttpClient)this.createHttpClient(properties);
        HttpRequestBase request = this.createRequestMethod(httpClient, properties, environment);
        return this.execute(httpClient, request, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream execute(HttpClient httpClient, HttpRequestBase request, Properties properties) throws Exception {
        String loginQueryString = properties.getProperty("requestLoginQueryString");
        String logoutQueryString = properties.getProperty("requestLogoutQueryString");
        try {
            if (null != loginQueryString) {
                this.executeLogin(httpClient, properties, loginQueryString);
            }
            InputStream inputStream = this.executeRequestMethod(httpClient, request);
            if (null != logoutQueryString) {
                this.executeLogout(httpClient, properties, logoutQueryString);
            }
            httpClient.getConnectionManager().shutdown();
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private void executeLogin(HttpClient httpClient, Properties properties, String loginQueryString) throws Exception {
        if (null != loginQueryString) {
            String userid = properties.getProperty("requestLoginUserid");
            if (null == userid) {
                userid = properties.getProperty("username");
            }
            if (null == userid) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC159E, "requestLoginUserid", "username");
                throw new Exception(NodeMessage.JEMC159E.toMessage().getFormattedMessage("requestLoginUserid", "username"));
            }
            String password = properties.getProperty("requestLoginPassword");
            if (null == password) {
                password = properties.getProperty("password");
            }
            if (null == password) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC159E, "requestLoginPassword", "password");
                throw new Exception(NodeMessage.JEMC159E.toMessage().getFormattedMessage("requestLoginPassword", "password"));
            }
            String paramUserid = properties.getProperty("requestLoginParamUserid");
            if (null == paramUserid) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC160E, "requestLoginParamUserid");
                throw new Exception(NodeMessage.JEMC160E.toMessage().getFormattedMessage("requestLoginParamUserid"));
            }
            String paramPassword = properties.getProperty("requestLoginParamPassword");
            if (null == paramPassword) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC160E, "requestLoginParamPassword");
                throw new Exception(NodeMessage.JEMC160E.toMessage().getFormattedMessage("requestLoginParamPassword"));
            }
            String url = this.createRequestUrl(properties, loginQueryString);
            Properties parameters = new Properties();
            parameters.setProperty(paramUserid, userid);
            parameters.setProperty(paramPassword, password);
            String parametersCharsetFormat = (String)httpClient.getParams().getParameter("http.protocol.content-charset");
            HttpPost request = this.createHttpPostMethod(parameters, url, parametersCharsetFormat);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            httpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
            request.abort();
        }
    }

    private void executeLogout(HttpClient httpClient, Properties properties, String logoutQueryString) throws Exception {
        String url = this.createRequestUrl(properties, logoutQueryString);
        String parametersCharsetFormat = (String)httpClient.getParams().getParameter("http.protocol.content-charset");
        HttpPost request = this.createHttpPostMethod(null, url, parametersCharsetFormat);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        httpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
        request.abort();
    }

    private InputStream executeRequestMethod(HttpClient httpClient, HttpRequestBase request) throws Exception {
        InputStream instream = null;
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            String responseBody = (String)httpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
            instream = new ByteArrayInputStream(responseBody.getBytes());
            request.abort();
            return instream;
        }
        catch (Exception ex) {
            request.abort();
            if (null != instream) {
                instream.close();
            }
            throw new Exception(NodeMessage.JEMC157E.toMessage().getFormattedMessage(ex.getMessage()), ex);
        }
    }

    private Object findEnvironmentProperty(Hashtable environment, String propertyName) {
        Object properyValue = null;
        try {
            properyValue = environment.get(propertyName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC158W, ex, propertyName);
        }
        return properyValue;
    }

    private HttpRequestBase createRequestMethod(HttpClient httpClient, Properties properties, Hashtable environment) throws Exception {
        String path = (String)this.findEnvironmentProperty(environment, "requestPath");
        Map parameters = (Map)this.findEnvironmentProperty(environment, "requestParameters");
        String queryString = (String)this.findEnvironmentProperty(environment, "requestQueryString");
        String requestMethod = (String)this.findEnvironmentProperty(environment, "requestMethod");
        String parametersCharsetFormat = (String)httpClient.getParams().getParameter("http.protocol.content-charset");
        String url = this.createRequestUrl(properties, path);
        if (null == requestMethod) {
            requestMethod = "GET";
        }
        Object request = null;
        request = requestMethod.equalsIgnoreCase("GET") ? this.createHttpGetMethod(parameters, url, queryString) : this.createHttpPostMethod(parameters, url, queryString, parametersCharsetFormat);
        return request;
    }

    private HttpGet createHttpGetMethod(Map<String, String> parameters, String url, String queryString) throws Exception {
        URIBuilder builder = new URIBuilder(url);
        if (null != queryString) {
            builder.setQuery(queryString);
        } else if (null != parameters && parameters.size() > 0) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                builder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        URI uri = builder.build();
        HttpGet request = new HttpGet(uri.toString());
        return request;
    }

    private HttpPost createHttpPostMethod(Map<String, String> parameters, String url, String queryString, String parametersCharsetFormat) throws Exception {
        URIBuilder builder = new URIBuilder(url);
        if (null != queryString) {
            builder.setQuery(queryString);
        }
        URI uri = builder.build();
        HttpPost request = new HttpPost(uri.toString());
        if (null != parameters && parameters.size() > 0) {
            ArrayList<BasicNameValuePair> parametersList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                parametersList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (null == parametersCharsetFormat) {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(parametersList));
            } else {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(parametersList, parametersCharsetFormat));
            }
        }
        return request;
    }

    private HttpPost createHttpPostMethod(Map parameters, String url, String parametersCharsetFormat) throws Exception {
        return this.createHttpPostMethod(parameters, url, null, parametersCharsetFormat);
    }

    public String createRequestUrl(Properties properties, String requestPath) throws Exception {
        String hostName = properties.getProperty("requestHostName");
        if (null == hostName) {
            throw new Exception(NodeMessage.JEMC136E.toMessage().getFormattedMessage("requestHostName"));
        }
        String port = properties.getProperty("requestPort");
        String protocolType = properties.getProperty("protocolType");
        if (null == protocolType) {
            protocolType = "http";
        }
        URIBuilder builder = new URIBuilder();
        builder.setScheme(protocolType);
        builder.setHost(hostName);
        if (null != port) {
            builder.setPort(Parser.parseInt(port));
        }
        if (null != requestPath) {
            builder.setPath(requestPath);
        }
        return builder.build().toString();
    }

    private Object createHttpClient(Properties properties) throws Exception {
        try {
            String strictTransferEncodingStr;
            String userAgent;
            String httpContentCharset;
            String httpElementCharset;
            String protocolVersion;
            PoolingClientConnectionManager conMan = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault());
            String loginQueryString = properties.getProperty("requestLoginQueryString");
            String logoutQueryString = properties.getProperty("requestLogoutQueryString");
            DefaultHttpClient httpClient = null;
            httpClient = null == loginQueryString && null == logoutQueryString ? new DefaultHttpClient() : new DefaultHttpClient((ClientConnectionManager)conMan);
            httpClient.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            InetAddress originAddress = InetAddress.getLocalHost();
            httpClient.getParams().setParameter("http.origin-server", (Object)originAddress);
            String proxyUrl = properties.getProperty("proxyUrl");
            String proxyPortStr = properties.getProperty("proxyPort");
            String proxyProtocol = properties.getProperty("proxyProtocol");
            int proxyPort = Parser.parseInt(proxyPortStr);
            String username = properties.getProperty("username");
            String password = properties.getProperty("password");
            String credentialCharset = properties.getProperty("http.auth.credential-charset");
            if (null != proxyUrl) {
                this.configureProxy(httpClient, proxyUrl, proxyPort, proxyProtocol, username, password, credentialCharset);
            }
            String protocolType = properties.getProperty("protocolType");
            String port = properties.getProperty("requestPort");
            if (null != protocolType) {
                this.configureSSL((HttpClient)httpClient, protocolType, port);
            }
            if (null != (protocolVersion = properties.getProperty("http.protocol.version"))) {
                httpClient.getParams().setParameter("http.protocol.version", (Object)HttpFactory.getHttpVersion(protocolVersion));
            }
            if (null != (httpElementCharset = properties.getProperty("http.protocol.element-charset"))) {
                httpClient.getParams().setParameter("http.protocol.element-charset", (Object)httpElementCharset);
            }
            if (null != (httpContentCharset = properties.getProperty("http.protocol.content-charset"))) {
                httpClient.getParams().setParameter("http.protocol.content-charset", (Object)httpContentCharset);
            }
            if (null != (userAgent = properties.getProperty("http.useragent"))) {
                httpClient.getParams().setParameter("http.useragent", (Object)userAgent);
            }
            if (null != (strictTransferEncodingStr = properties.getProperty("http.protocol.strict-transfer-encoding"))) {
                boolean strictTransferEncoding = Parser.parseBoolean(strictTransferEncodingStr, false);
                httpClient.getParams().setParameter("http.protocol.strict-transfer-encoding", (Object)strictTransferEncoding);
            }
            String useExpectContinueStr = properties.getProperty("http.protocol.expect-continue");
            String waitForContinueStr = properties.getProperty("http.protocol.wait-for-continue");
            if (null != useExpectContinueStr && null != waitForContinueStr) {
                boolean useExpectContinue = Parser.parseBoolean(useExpectContinueStr, false);
                int waitForContinue = Parser.parseInt(waitForContinueStr);
                this.setExpectContinue(httpClient, useExpectContinue, waitForContinue);
            }
            return httpClient;
        }
        catch (Exception ex) {
            throw new Exception(NodeMessage.JEMC156E.toMessage().getFormattedMessage(ex.getMessage()), ex);
        }
    }

    private void configureProxy(DefaultHttpClient httpClient, String proxyUrl, int proxyPort, String proxyProtocol, String userid, String password, String credentialCharset) {
        HttpHost proxy = null;
        proxy = null != proxyProtocol ? new HttpHost(proxyUrl, proxyPort, proxyProtocol) : new HttpHost(proxyUrl, proxyPort);
        if (null != userid && null != password) {
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(userid, password));
        }
        if (null != credentialCharset) {
            httpClient.getParams().setParameter("http.auth.credential-charset", (Object)credentialCharset);
        }
        httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    private void configureSSL(HttpClient httpClient, String protocolType, String port) throws Exception {
        if (protocolType.equalsIgnoreCase("https")) {
            SSLSocketFactory sf = this.buildSSLSocketFactory();
            int httpsPort = 443;
            if (null != port) {
                httpsPort = Parser.parseInt(port);
            }
            Scheme https = new Scheme("https", httpsPort, (SchemeSocketFactory)sf);
            SchemeRegistry sr = httpClient.getConnectionManager().getSchemeRegistry();
            sr.register(https);
        }
    }

    private SSLSocketFactory buildSSLSocketFactory() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy ts = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        return new SSLSocketFactory(ts, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    private void setExpectContinue(DefaultHttpClient httpClient, boolean useExpectContinue, int waitForContinue) {
        httpClient.getParams().setParameter("http.protocol.expect-continue", (Object)useExpectContinue);
        httpClient.getParams().setParameter("http.protocol.wait-for-continue", (Object)waitForContinue);
    }

    private static HttpVersion getHttpVersion(String httpVersionStr) {
        HttpVersion version = HttpVersion.HTTP_1_0;
        if (null != httpVersionStr) {
            if (httpVersionStr.trim().equalsIgnoreCase(HttpVersion.HTTP_0_9.toString())) {
                return HttpVersion.HTTP_0_9;
            }
            if (httpVersionStr.trim().equalsIgnoreCase(HttpVersion.HTTP_1_1.toString())) {
                return HttpVersion.HTTP_1_1;
            }
        }
        return version;
    }
}

