/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.jndi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.FtpResource;
import org.pepstock.jem.node.tasks.jndi.FtpInputStream;
import org.pepstock.jem.node.tasks.jndi.FtpOutputStream;
import org.pepstock.jem.util.Parser;

public class FtpFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        Properties properties = new Properties();
        for (int i = 0; i < FtpResource.PROPERTIES_ALL.size(); ++i) {
            String propertyName = FtpResource.PROPERTIES_ALL.get(i);
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return FtpFactory.createFtpClient(properties);
    }

    public static Object createFtpClient(Properties properties) throws Exception {
        String ftpUrlString = properties.getProperty("url");
        if (ftpUrlString == null) {
            throw new Exception(NodeMessage.JEMC136E.toMessage().getFormattedMessage("url"));
        }
        URL ftpUrl = new URL(ftpUrlString);
        if (!ftpUrl.getProtocol().equalsIgnoreCase("ftp") && !ftpUrl.getProtocol().equalsIgnoreCase("ftps")) {
            throw new Exception(NodeMessage.JEMC137E.toMessage().getFormattedMessage(ftpUrl.getProtocol()));
        }
        int port = ftpUrl.getPort();
        String server = ftpUrl.getHost();
        String username = properties.getProperty("username");
        if (username == null) {
            throw new Exception(NodeMessage.JEMC136E.toMessage().getFormattedMessage("username"));
        }
        String password = properties.getProperty("password");
        if (password == null) {
            throw new Exception(NodeMessage.JEMC136E.toMessage().getFormattedMessage("password"));
        }
        String remoteFile = properties.getProperty("remoteFile");
        if (remoteFile == null) {
            throw new Exception(NodeMessage.JEMC136E.toMessage().getFormattedMessage("remoteFile"));
        }
        String accessMode = properties.getProperty("action", "read");
        FTPClient ftp = ftpUrl.getProtocol().equalsIgnoreCase("ftp") ? new FTPClient() : new FTPSClient();
        boolean binaryTransfer = Parser.parseBoolean(properties.getProperty("binary", "false"), false);
        try {
            if (port > 0) {
                ftp.connect(server, port);
            } else {
                ftp.connect(server);
            }
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                throw new IOException(NodeMessage.JEMC138E.toMessage().getFormattedMessage(reply));
            }
            if (!ftp.login(username, password)) {
                ftp.logout();
            }
            if (binaryTransfer) {
                ftp.setFileType(2);
            }
            if (accessMode.equalsIgnoreCase("write")) {
                OutputStream os = ftp.storeFileStream(remoteFile);
                if (os == null) {
                    reply = ftp.getReplyCode();
                    throw new IOException(NodeMessage.JEMC206E.toMessage().getFormattedMessage(remoteFile, reply));
                }
                return new FtpOutputStream(os, ftp);
            }
            InputStream is = ftp.retrieveFileStream(remoteFile);
            if (is == null) {
                reply = ftp.getReplyCode();
                throw new IOException(NodeMessage.JEMC206E.toMessage().getFormattedMessage(remoteFile, reply));
            }
            return new FtpInputStream(is, ftp);
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw e;
        }
    }
}

