/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks.jndi;

import com.thoughtworks.xstream.XStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.node.NodeMessage;

public class DataStreamFactory
implements ObjectFactory {
    private XStream xstream = new XStream();

    @Override
    public Object getObjectInstance(Object object, Name name, Context ctx, Hashtable<?, ?> env) throws Exception {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            RefAddr datastreams_a = reference.get("jem.datadescrition.object");
            DataDescriptionImpl ddImpl = (DataDescriptionImpl)this.xstream.fromXML((String)datastreams_a.getContent());
            if (ddImpl.getDisposition().equalsIgnoreCase("SHR")) {
                if (ddImpl.getDataSetsImpl().size() > 1) {
                    ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
                    for (DataSetImpl dstream : ddImpl.getDataSetsImpl()) {
                        inputStreams.add(this.getInputStream(dstream, ctx));
                    }
                    return new SequenceInputStream(Collections.enumeration(inputStreams));
                }
                DataSetImpl dstream = ddImpl.getDataSetsImpl().get(0);
                return this.getInputStream(dstream, ctx);
            }
            DataSetImpl dstream = ddImpl.getDataSetsImpl().get(0);
            return this.getOutputStream(ddImpl, dstream, ctx);
        }
        throw new Exception(NodeMessage.JEMC133E.toMessage().getFormattedMessage(object.getClass().getName()));
    }

    private InputStream getInputStream(DataSetImpl ds, Context ctx) throws Exception {
        if (ds.getType() != 6) {
            return new FileInputStream(ds.getRealFile());
        }
        Object object = ctx.lookup(ds.getDataSource());
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        throw new Exception(NodeMessage.JEMC132E.toMessage().getFormattedMessage(ds.getDataSource()));
    }

    private OutputStream getOutputStream(DataDescriptionImpl dd, DataSetImpl ds, Context ctx) throws Exception {
        if (ds.getType() == 2) {
            throw new Exception(NodeMessage.JEMC135E.toMessage().getMessage());
        }
        if (ds.getType() == 6) {
            Object object = ctx.lookup(ds.getDataSource());
            if (object instanceof OutputStream) {
                return (OutputStream)object;
            }
            throw new Exception(NodeMessage.JEMC134E.toMessage().getFormattedMessage(ds.getDataSource()));
        }
        return new FileOutputStream(ds.getRealFile(), dd.getDisposition().equalsIgnoreCase("MOD"));
    }
}

