/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks;

import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.Result;
import org.pepstock.jem.factories.AbstractFactory;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.JobLogManager;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.RolesQueuePredicate;
import org.pepstock.jem.node.security.User;
import org.pepstock.jem.node.tasks.CommandLineTask;
import org.pepstock.jem.node.tasks.JavaUtils;
import org.pepstock.jem.node.tasks.platform.CurrentPlatform;
import org.pepstock.jem.node.tasks.shell.Shell;
import org.pepstock.jem.util.Parser;

public abstract class JobTask
extends CommandLineTask {
    private static final long serialVersionUID = 1L;
    private Job job = null;
    private Process process = null;
    private boolean isCancelled = false;
    private Result result = new Result();
    private JemFactory factory = null;
    private ArrayList<Role> roles = null;

    public JobTask(Job job, JemFactory factory) {
        this.setJob(job);
        this.setFactory(factory);
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Job getJob() {
        return this.job;
    }

    public JemFactory getFactory() {
        return this.factory;
    }

    public void setFactory(JemFactory factory) {
        this.factory = factory;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Process getProcess() {
        return this.process;
    }

    public ArrayList<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(ArrayList<Role> roles) {
        this.roles = roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Result call() throws Exception {
        ArrayList<Role> myroles;
        block10: {
            User user;
            Main.OUTPUT_SYSTEM.writeJcl(this.job);
            this.setStartDir(Main.OUTPUT_SYSTEM.getCurrentPath().getAbsolutePath());
            this.configure();
            if (this.job.isUserSurrogated()) {
                user = new User(this.job.getJcl().getUser());
            } else {
                user = new User(this.job.getUser());
                user.setOrgUnitId(this.job.getOrgUnit());
            }
            if (!this.getEnv().containsKey("CLASSPATH")) {
                this.getEnv().put("CLASSPATH", JavaUtils.getClassPath());
            }
            RolesQueuePredicate predicate = new RolesQueuePredicate();
            predicate.setUser(user);
            myroles = null;
            try {
                IMap roles = Main.HAZELCAST.getMap("org.pepstock.jem.roles");
                if (roles.lockMap(10L, TimeUnit.SECONDS)) {
                    try {
                        myroles = new ArrayList<Role>(roles.values((Predicate)predicate));
                        break block10;
                    }
                    finally {
                        roles.unlockMap();
                    }
                }
                throw new Exception(NodeMessage.JEMC119E.toMessage().getFormattedMessage("org.pepstock.jem.roles"));
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC103E, user, e);
                throw e;
            }
        }
        this.setRoles(myroles);
        int returnCode = this.launchProcess();
        if (returnCode != 0 && returnCode > this.result.getReturnCode()) {
            this.result.setReturnCode(returnCode);
        }
        return this.result;
    }

    public abstract void configure() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int launchProcess() throws Exception {
        int returnCode = 0;
        Process process = null;
        try {
            String user = this.job.isUserSurrogated() ? this.job.getJcl().getUser() : this.job.getUser();
            AbstractFactory factory = (AbstractFactory)this.getFactory();
            boolean useSudo = factory.isUseSudo() && !user.equalsIgnoreCase(Main.NODE.getUser());
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            Shell shell = CurrentPlatform.getInstance().getShell();
            String command = CurrentPlatform.getInstance().getCommand(this.job, this.getCommand(), useSudo);
            builder.command(shell.getName(), shell.getParameters(), command);
            if (this.getStartDir() != null) {
                builder.directory(new File(this.getStartDir()));
            }
            Map<String, String> env = this.getEnv();
            Map<String, String> map = builder.environment();
            for (Map.Entry<String, String> e : env.entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
            JobLogManager.printHeader(this.job);
            process = builder.start();
            returnCode = process.waitFor();
            if (this.isCancelled) {
                returnCode = 222;
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return returnCode;
    }

    public final void cancel(String pid, boolean force) {
        String id = StringUtils.substringBefore((String)this.getJob().getProcessId(), (String)"@");
        long intId = Parser.parseLong(id, -1L);
        if (intId == -1L) {
            return;
        }
        try {
            String user = this.job.isUserSurrogated() ? this.job.getJcl().getUser() : this.job.getUser();
            AbstractFactory factory = (AbstractFactory)this.getFactory();
            boolean useSudo = factory.isUseSudo() && !user.equalsIgnoreCase(Main.NODE.getUser());
            this.isCancelled = true;
            this.isCancelled = CurrentPlatform.getInstance().kill(intId, user, force, useSudo);
        }
        catch (Exception e) {
            this.isCancelled = false;
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC017E, e);
        }
    }
}

