/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks;

import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.tasks.Libraries;

public class JavaUtils {
    private static final String INITIAL_HEAP_SIZE = "-Xms64M";
    private static final String MAXIMUM_HEAP_SIZE = "-Xmx{0}M";
    private static String maximumHeapSize = null;

    public static String getInitialHeapSize() {
        return INITIAL_HEAP_SIZE;
    }

    public static String getMaximumHeapSize() {
        if (maximumHeapSize == null) {
            maximumHeapSize = MessageFormat.format(MAXIMUM_HEAP_SIZE, String.valueOf(Main.EXECUTION_ENVIRONMENT.getMemory()));
        }
        return maximumHeapSize;
    }

    public static String getClassPath() {
        return JavaUtils.getClassPath(null);
    }

    public static String getClassPath(String[] additionalFolders) {
        String classPath = null;
        String pathSeparator = System.getProperty("path.separator");
        String classPathProperty = System.getProperty("java.class.path");
        String[] filesNames = classPathProperty.split(pathSeparator);
        for (int i = 0; i < filesNames.length; ++i) {
            String ext;
            File file = new File(filesNames[i]);
            if (!JavaUtils.isToAdd(file, additionalFolders) || !(ext = FilenameUtils.getExtension((String)file.getAbsolutePath())).equalsIgnoreCase("jar") && !ext.equalsIgnoreCase("zip") && !file.isDirectory()) continue;
            classPath = i == 0 ? file.getAbsolutePath() : classPath + pathSeparator + file.getAbsolutePath();
        }
        return classPath;
    }

    private static boolean isToAdd(File file, String[] additionalFolders) {
        if (file.isDirectory()) {
            return true;
        }
        if (file.getName().startsWith("jem")) {
            return true;
        }
        String path = file.getParentFile().getName();
        for (Libraries lib : Libraries.values()) {
            if (!path.equalsIgnoreCase(lib.getPath())) continue;
            return true;
        }
        if (additionalFolders != null) {
            for (int i = 0; i < additionalFolders.length; ++i) {
                if (!path.equalsIgnoreCase(additionalFolders[i])) continue;
                return true;
            }
        }
        return false;
    }
}

