/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks;

import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.List;
import org.pepstock.catalog.DataDescriptionImpl;
import org.pepstock.catalog.DataSetImpl;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.ResourceLock;
import org.pepstock.jem.node.rmi.CommonResourcer;
import org.pepstock.jem.node.rmi.ResourceLocker;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.rmi.RegistryLocator;

public class InitiatorManager {
    public static ResourceLocker getResourceLocker() throws RemoteException, UnknownHostException {
        ResourceLocker locker = null;
        String port = System.getProperty("jem.rmi.port");
        if (port == null) {
            throw new RemoteException(NodeMessage.JEMC141E.toMessage().getFormattedMessage("jem.rmi.port"));
        }
        RegistryLocator locator = new RegistryLocator(Parser.parseInt(port));
        if (!locator.hasRmiObject("RESOURCE_LOCKER")) {
            throw new RemoteException(NodeMessage.JEMC142E.toMessage().getFormattedMessage("RESOURCE_LOCKER"));
        }
        locker = (ResourceLocker)locator.getRmiObject("RESOURCE_LOCKER");
        return locker;
    }

    public static CommonResourcer getCommonResourcer() throws RemoteException, UnknownHostException {
        CommonResourcer resourcer = null;
        String port = System.getProperty("jem.rmi.port");
        if (port == null) {
            throw new RemoteException(NodeMessage.JEMC141E.toMessage().getFormattedMessage("jem.rmi.port"));
        }
        RegistryLocator locator = new RegistryLocator(Parser.parseInt(port));
        if (!locator.hasRmiObject("COMMON_RESOURCE")) {
            throw new RemoteException(NodeMessage.JEMC142E.toMessage().getFormattedMessage("COMMON_RESOURCE"));
        }
        resourcer = (CommonResourcer)locator.getRmiObject("COMMON_RESOURCE");
        return resourcer;
    }

    public static void addResourcesLock(DataDescriptionImpl ddImpl, List<ResourceLock> resources) {
        if (ddImpl.isSysout()) {
            return;
        }
        for (DataSetImpl dataset : ddImpl.getDataSetsImpl()) {
            if (dataset.getType() == 6 || dataset.getType() == 2 || dataset.getType() == 1) continue;
            ResourceLock resource = new ResourceLock(dataset.getName(), ddImpl.getDisposition().equalsIgnoreCase("SHR") ? 0 : 1);
            resources.add(resource);
        }
    }
}

