/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.tasks;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.tasks.JavaUtils;
import org.pepstock.jem.node.tasks.JobTask;
import org.pepstock.jem.node.tasks.shell.JavaCommand;

public class DefaultJobTask
extends JobTask {
    private static final long serialVersionUID = 1L;
    private String home = "-DJEM_HOME=" + System.getProperty("JEM_HOME");
    private String rmiPort = "-Djem.rmi.port=" + Main.NODE.getRmiPort();
    private String dataPath = "-Djem.data=" + System.getProperty("jem.data");
    private String binPath = "-Djem.binary=" + System.getProperty("jem.binary");
    private String classPath = "-Djem.classpath=" + System.getProperty("jem.classpath");
    private String libPath = "-Djem.library=" + System.getProperty("jem.library");
    private String srcPath = "-Djem.source=" + System.getProperty("jem.source");
    private String persistencePath = "-Djem.persistence=" + System.getProperty("jem.persistence");

    public DefaultJobTask(Job job, JemFactory factory) {
        super(job, factory);
    }

    @Override
    public void configure() throws Exception {
        Job job = this.getJob();
        String initHeap = JavaUtils.getInitialHeapSize();
        String maxHeap = JavaUtils.getMaximumHeapSize();
        File jclFile = Main.OUTPUT_SYSTEM.getJclFile(job);
        JavaCommand command = new JavaCommand();
        command.setJavaOptions(initHeap, maxHeap, this.getHome(), this.getRmiPort(), this.getClassPath(), this.getBinPath(), this.getDataPath(), this.getLibPath(), "-Djem.output=" + FilenameUtils.normalize((String)jclFile.getParentFile().getAbsolutePath(), (boolean)true), this.getSrcPath(), this.getPersistencePath());
        this.setCommand(command);
    }

    public String getHome() {
        return this.home;
    }

    public String getRmiPort() {
        return this.rmiPort;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getBinPath() {
        return this.binPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public String getPersistencePath() {
        return this.persistencePath;
    }

    public void setPersistencePath(String persistencePath) {
        this.persistencePath = persistencePath;
    }
}

