/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.system;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.hyperic.sigar.ProcStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.pepstock.jem.node.system.Ps;
import org.pepstock.jem.node.system.Uptime;

public class Top
implements Callable<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String[] HEADER = new String[]{"PID ", "USER    ", "STIME   ", "SIZE    ", "RSS     ", "SHARE   ", "STATE   ", "TIME    ", "%CPU  ", "COMMAND"};

    @Override
    public String call() throws Exception {
        Sigar sigar = new Sigar();
        StringBuffer sb = new StringBuffer();
        try {
            for (int k = 0; k < 2; ++k) {
                sb.append(Uptime.getInfo((SigarProxy)sigar));
                sb.append('\n');
                sb.append(this.toString(sigar.getProcStat()));
                sb.append('\n');
                sb.append(sigar.getCpuPerc());
                sb.append('\n');
                sb.append(sigar.getMem());
                sb.append('\n');
                sb.append(sigar.getSwap());
                sb.append('\n');
                sb.append('\n');
                for (int i = 0; i < HEADER.length; ++i) {
                    sb.append(HEADER[i]).append(' ');
                }
                sb.append('\n');
                long[] pids = sigar.getProcList();
                for (int i = 0; i < pids.length; ++i) {
                    List<String> info;
                    long pid = pids[i];
                    try {
                        info = Ps.getInfo((SigarProxy)sigar, pid);
                    }
                    catch (SigarException e) {
                        continue;
                    }
                    sb.append(Ps.join(info));
                    sb.append('\n');
                }
                if (k != 0) continue;
                sb.delete(0, sb.length());
                Thread.sleep(1000L);
            }
        }
        catch (SigarException e1) {
            e1.printStackTrace();
            throw new Exception(e1.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return sb.toString();
    }

    private String toString(ProcStat stat) {
        return stat.getTotal() + " processes: " + stat.getSleeping() + " sleeping, " + stat.getRunning() + " running, " + stat.getZombie() + " zombie, " + stat.getStopped() + " stopped... " + stat.getThreads() + " threads";
    }
}

