/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.system;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.ProcUtil;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.pepstock.jem.node.system.Top;

public class Ps {
    private static final String UNKNOWN = "???";

    public static String join(List<String> info) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < Top.HEADER.length; ++i) {
            int len = Top.HEADER[i].length();
            buf.append(StringUtils.rightPad((String)info.get(i), (int)len, (char)' ')).append(' ');
        }
        return buf.toString();
    }

    public static List<String> getInfo(SigarProxy sigar, long pid) throws SigarException {
        ProcState state = sigar.getProcState(pid);
        ProcTime time = null;
        String cpuPerc = UNKNOWN;
        ArrayList<String> info = new ArrayList<String>();
        info.add(String.valueOf(pid));
        try {
            ProcCredName cred = sigar.getProcCredName(pid);
            info.add(cred.getUser());
        }
        catch (SigarException e) {
            info.add(UNKNOWN);
        }
        try {
            time = sigar.getProcTime(pid);
            info.add(Ps.getStartTime(time.getStartTime()));
        }
        catch (SigarException e) {
            info.add(UNKNOWN);
        }
        try {
            ProcMem mem = sigar.getProcMem(pid);
            info.add(Sigar.formatSize((long)mem.getSize()));
            info.add(Sigar.formatSize((long)mem.getResident()));
            info.add(Sigar.formatSize((long)mem.getShare()));
        }
        catch (SigarException e) {
            info.add(UNKNOWN);
        }
        info.add(String.valueOf(state.getState()));
        if (time != null) {
            info.add(Ps.getCpuTime(time));
        } else {
            info.add(UNKNOWN);
        }
        try {
            ProcCpu cpu = sigar.getProcCpu(pid);
            cpuPerc = CpuPerc.format((double)cpu.getPercent());
            info.add(cpuPerc);
        }
        catch (SigarException e) {
            info.add(UNKNOWN);
        }
        String name = ProcUtil.getDescription((SigarProxy)sigar, (long)pid);
        info.add(name);
        return info;
    }

    private static String getCpuTime(long total) {
        long t = total / 1000L;
        return t / 60L + ":" + t % 60L;
    }

    private static String getCpuTime(ProcTime time) {
        return Ps.getCpuTime(time.getTotal());
    }

    private static String getStartTime(long time) {
        if (time == 0L) {
            return "00:00";
        }
        long timeNow = System.currentTimeMillis();
        String fmt = "MMMd";
        if (timeNow - time < 86400000L) {
            fmt = "HH:mm";
        }
        return new SimpleDateFormat(fmt).format(new Date(time));
    }
}

