/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.system;

import java.lang.management.ManagementFactory;
import org.apache.commons.lang3.StringUtils;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.pepstock.jem.Job;
import org.pepstock.jem.JobSystemActivity;
import org.pepstock.jem.OSProcess;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.executors.DefaultExecutor;
import org.pepstock.jem.util.Parser;

public class GetJobSystemActivity
extends DefaultExecutor<JobSystemActivity> {
    private static final long serialVersionUID = 1L;
    private Job job = null;
    private static final long INTERVAL = 500L;

    public GetJobSystemActivity(Job job) {
        this.job = job;
    }

    @Override
    public JobSystemActivity call() throws Exception {
        String pid;
        long longPid;
        JobSystemActivity activity = new JobSystemActivity();
        if (Main.CURRENT_TASK != null && Main.CURRENT_TASK.getJobTask().getJob().equals(this.job) && (longPid = Parser.parseLong(pid = StringUtils.substringBefore((String)this.job.getProcessId(), (String)"@"), -1L)) != -1L) {
            Sigar sigar = new Sigar();
            SigarProxy proxyFirst = SigarProxyCache.newInstance((Sigar)sigar, (int)0);
            OSProcess head = this.getProcessesTree(longPid, proxyFirst);
            long cpu_First = this.getCpu(head);
            sigar.close();
            SigarProxyCache.clear((Object)proxyFirst);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            sigar = new Sigar();
            SigarProxy proxyLast = SigarProxyCache.newInstance((Sigar)sigar, (int)0);
            head = this.getProcessesTree(longPid, proxyLast);
            long cpu_Last = this.getCpu(head);
            long cpu_used = cpu_Last - cpu_First;
            long tot_possible_cpu = 500L * (long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            double cpu_used_percent = (double)cpu_used * 1.0 / (double)tot_possible_cpu;
            cpu_used_percent = Math.min(Math.max(cpu_used_percent, 0.0), 1.0);
            activity.setCpu(cpu_Last);
            activity.setCpuPerc(cpu_used_percent);
            activity.setMemory(this.getMemory(head));
            activity.setActive(true);
            sigar.close();
            activity.setProcess(head);
        }
        return activity;
    }

    private long getCpu(OSProcess head) {
        return this.getCpu(head, 0L);
    }

    private long getCpu(OSProcess child, long total) {
        total += child.getCpu();
        for (OSProcess process : child.getChildren()) {
            total = this.getCpu(process, total);
        }
        return total;
    }

    private long getMemory(OSProcess head) {
        return this.getMemory(head, 0L);
    }

    private long getMemory(OSProcess child, long total) {
        total += child.getMemory();
        for (OSProcess process : child.getChildren()) {
            total = this.getMemory(process, total);
        }
        return total;
    }

    private OSProcess getProcessesTree(long pid, SigarProxy proxy) throws SigarException {
        OSProcess head = new OSProcess();
        head.setPid(pid);
        head.setCommand(proxy.getProcState(pid).getName());
        head.setMemory(proxy.getProcMem(pid).getResident());
        head.setCpu(proxy.getProcCpu(pid).getTotal());
        long[] allProcessesId = proxy.getProcList();
        this.loadChildrenProcessId(head, allProcessesId, proxy);
        return head;
    }

    private void loadChildrenProcessId(OSProcess parent, long[] allProcessesId, SigarProxy proxy) {
        for (long processId : allProcessesId) {
            try {
                ProcState state = proxy.getProcState(processId);
                if (state.getPpid() != parent.getPid()) continue;
                OSProcess proc = new OSProcess();
                proc.setPid(processId);
                proc.setCommand(state.getName());
                proc.setMemory(proxy.getProcMem(processId).getResident());
                proc.setCpu(proxy.getProcCpu(processId).getTotal());
                parent.getChildren().add(proc);
                this.loadChildrenProcessId(proc, allProcessesId, proxy);
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
    }
}

