/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.stats;

import java.io.File;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.stats.Sample;
import org.pepstock.jem.node.stats.TransformAndLoader;

public class DefaultTransformAndLoader
implements TransformAndLoader {
    private boolean toDelete = true;

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Override
    public void fileStarted(File file) throws Exception {
        this.setToDelete(true);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC148I, file.getAbsolutePath());
    }

    @Override
    public void fileEnded(File file) throws Exception {
        if (this.isToDelete()) {
            boolean removed = file.delete();
            if (removed) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC149I, file.getAbsolutePath());
            } else {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC150W, file.getAbsolutePath());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC151W, file.getAbsolutePath());
        }
    }

    @Override
    public void loadSuccess(Sample sample) throws Exception {
    }

    @Override
    public void loadFailed(String record, int line, Exception exception) throws Exception {
        this.setToDelete(false);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC152E, String.valueOf(line), exception.getMessage());
    }
}

