/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.socketinterceptor;

import com.hazelcast.nio.SocketInterceptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.Key;
import org.apache.shiro.codec.Base64;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.Crypto;
import org.pepstock.jem.node.security.loginprotocol.ClientLoginProtocol;

public class SubmitInterceptor
implements SocketInterceptor {
    private Key privateKey;
    private String subjectId;

    public SubmitInterceptor(String privateKeFilePath, String keyPassword, String subjectId) throws Exception {
        this.privateKey = Crypto.loadPrivateKeyFromFile(new File(privateKeFilePath), keyPassword);
        this.subjectId = subjectId;
    }

    public void onConnect(Socket connectedSocket) throws IOException {
        LogAppl.getInstance().emit(NodeMessage.JEMC202I);
        PrintWriter out = null;
        BufferedReader in = null;
        String address = null;
        try {
            String inputResponse;
            out = new PrintWriter(connectedSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(connectedSocket.getInputStream()));
            String ip = connectedSocket.getLocalAddress().getHostAddress();
            int port = connectedSocket.getLocalPort();
            address = ip + ":" + port;
            ClientLoginProtocol jemClientProtocol = new ClientLoginProtocol(this.privateKey);
            String request = jemClientProtocol.getRequestFromResponse(null, address, this.subjectId);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)request)));
            out.println(request);
            while ((inputResponse = in.readLine()) != null) {
                String outputRequest = jemClientProtocol.getRequestFromResponse(inputResponse, address, this.subjectId);
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)inputResponse)));
                if (outputRequest != null) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)outputRequest)));
                }
                if (!jemClientProtocol.isConversationTerminated()) {
                    if (jemClientProtocol.isServerException()) {
                        System.exit(1);
                    }
                    out.println(outputRequest);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogAppl.getInstance().emit(NodeMessage.JEMC106W);
            System.exit(1);
        }
    }
}

