/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.socketinterceptor;

import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.nio.MemberSocketInterceptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.Key;
import org.apache.shiro.codec.Base64;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.keystore.Factory;
import org.pepstock.jem.node.security.keystore.KeyStoresInfo;
import org.pepstock.jem.node.security.keystore.KeysUtil;
import org.pepstock.jem.node.security.loginprotocol.ClientLoginProtocol;
import org.pepstock.jem.node.security.loginprotocol.ServerLoginProtocol;

public class NodeInterceptor
implements MemberSocketInterceptor {
    private KeyStoresInfo keystoresInfo;

    public void init(SocketInterceptorConfig config) {
        this.keystoresInfo = Factory.createKeyStoresInfo(config);
    }

    public void onConnect(Socket connectedSocket) throws IOException {
        LogAppl.getInstance().emit(NodeMessage.JEMC202I);
        PrintWriter out = null;
        BufferedReader in = null;
        String address = null;
        try {
            String inputResponse;
            out = new PrintWriter(connectedSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(connectedSocket.getInputStream()));
            String ip = connectedSocket.getLocalAddress().getHostAddress();
            int port = connectedSocket.getLocalPort();
            address = ip + ":" + port;
            Key symmetricKey = KeysUtil.getSymmetricKey(this.keystoresInfo.getClusterKeystoreInfo());
            ClientLoginProtocol jemClientProtocol = new ClientLoginProtocol(symmetricKey);
            String request = jemClientProtocol.getRequestFromResponse(null, address, "JEM_NODE");
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)request)));
            out.println(request);
            while ((inputResponse = in.readLine()) != null) {
                String outputRequest = jemClientProtocol.getRequestFromResponse(inputResponse, address, "JEM_NODE");
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)inputResponse)));
                if (outputRequest != null) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)outputRequest)));
                }
                if (!jemClientProtocol.isConversationTerminated()) {
                    out.println(outputRequest);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogAppl.getInstance().emit(NodeMessage.JEMC106W);
            System.exit(1);
        }
    }

    public void onAccept(Socket acceptedSocket) throws IOException {
        LogAppl.getInstance().emit(NodeMessage.JEMC202I);
        String callingIp = acceptedSocket.getInetAddress().getHostAddress();
        int callingPort = acceptedSocket.getPort();
        String callingSubject = callingIp + ":" + callingPort;
        try {
            String inputRequest;
            acceptedSocket.setSoTimeout(30000);
            PrintWriter out = new PrintWriter(acceptedSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(acceptedSocket.getInputStream()));
            ServerLoginProtocol jemProtocol = new ServerLoginProtocol(this.keystoresInfo);
            while ((inputRequest = in.readLine()) != null) {
                String outputResponse = jemProtocol.getResponseFromRequest(inputRequest);
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)inputRequest)));
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC203I, new String(Base64.decode((String)outputResponse)));
                out.println(outputResponse);
                if (jemProtocol.isServerException()) {
                    Thread.sleep(1000L);
                    throw new Exception(NodeMessage.JEMC107W.toMessage().getFormattedMessage(callingSubject));
                }
                if (!jemProtocol.isConversationTerminated()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

