/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.loginprotocol;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.Crypto;
import org.pepstock.jem.node.security.keystore.KeyStoresInfo;
import org.pepstock.jem.node.security.keystore.KeysUtil;
import org.pepstock.jem.node.security.loginprotocol.LoginRequest;
import org.pepstock.jem.node.security.loginprotocol.LoginResponse;
import org.pepstock.jem.node.security.loginprotocol.Operation;
import org.pepstock.jem.node.security.loginprotocol.ResponseOperation;

public class ServerLoginProtocol {
    private Map<String, String> authorizedSubject = new HashMap<String, String>(1);
    private boolean conversationTerminated = false;
    private boolean serverException = false;
    private Key cryptographicKey;
    private KeyStoresInfo keystoresInfo;

    public ServerLoginProtocol(KeyStoresInfo keystoresInfo) {
        this.keystoresInfo = keystoresInfo;
    }

    public String getResponseFromRequest(String request) throws Exception {
        LoginResponse jemResponse;
        block9: {
            jemResponse = null;
            request = new String(Base64.decode(request));
            try {
                LoginRequest jemRequest = LoginRequest.unmarshall(request);
                String subjectId = jemRequest.getSubjectId();
                if (this.cryptographicKey == null) {
                    this.cryptographicKey = subjectId.equals("JEM_NODE") ? KeysUtil.getSymmetricKey(this.keystoresInfo.getClusterKeystoreInfo()) : KeysUtil.getPublicKeyByAlias(this.keystoresInfo.getUserKeystoreInfo(), subjectId);
                }
                if (jemRequest.getOperation().getName().equals(Operation.getPassword.toString())) {
                    jemResponse = new LoginResponse();
                    String randomPassword = UUID.randomUUID().toString();
                    jemResponse.setAddress(jemRequest.getAddress());
                    jemResponse.setSubjectId(jemRequest.getSubjectId());
                    ResponseOperation op = new ResponseOperation();
                    op.setName(Operation.getPassword.toString());
                    op.setResult(randomPassword);
                    jemResponse.setOperation(op);
                    this.authorizedSubject.put(jemRequest.getAddress(), randomPassword);
                    break block9;
                }
                if (jemRequest.getOperation().getName().equals(Operation.login.toString())) {
                    jemResponse = new LoginResponse();
                    String address = jemRequest.getAddress();
                    String clearPassword = null;
                    try {
                        clearPassword = new String(Crypto.decrypt(Base64.decode(jemRequest.getPassword()), this.cryptographicKey));
                    }
                    catch (Exception e) {
                        LogAppl.getInstance().emit(NodeMessage.JEMC204E);
                        throw e;
                    }
                    jemResponse.setAddress(address);
                    jemResponse.setSubjectId(jemRequest.getSubjectId());
                    ResponseOperation op = new ResponseOperation();
                    op.setName(Operation.login.toString());
                    if (this.authorizedSubject.containsKey(address) && this.authorizedSubject.get(address).equals(clearPassword)) {
                        op.setResult("accepted");
                        this.conversationTerminated = true;
                    } else {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC109W, "Wrong password");
                        LogAppl.getInstance().emit(NodeMessage.JEMC106W);
                        op.setResult("denied");
                        this.serverException = true;
                    }
                    jemResponse.setOperation(op);
                    break block9;
                }
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC109W, request);
                LogAppl.getInstance().emit(NodeMessage.JEMC106W);
                jemResponse = new LoginResponse();
                jemResponse.setException("bad request");
                this.serverException = true;
            }
            catch (Exception e) {
                jemResponse = new LoginResponse();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                jemResponse.setException(sw.toString());
                this.serverException = true;
            }
        }
        String xmlResponse = LoginResponse.marshall(jemResponse);
        String b64Encode = Base64.encode(xmlResponse.getBytes(), 2 * xmlResponse.length());
        return b64Encode;
    }

    public boolean isConversationTerminated() {
        return this.conversationTerminated;
    }

    public boolean isServerException() {
        return this.serverException;
    }
}

