/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.loginprotocol;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.Key;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.Crypto;
import org.pepstock.jem.node.security.loginprotocol.LoginRequest;
import org.pepstock.jem.node.security.loginprotocol.LoginResponse;
import org.pepstock.jem.node.security.loginprotocol.Operation;
import org.pepstock.jem.node.security.loginprotocol.RequestOperation;

public class ClientLoginProtocol {
    private boolean conversationTerminated = false;
    private boolean serverException = false;
    private Key cryptographicKey;

    public ClientLoginProtocol(Key cryptographicKey) {
        this.cryptographicKey = cryptographicKey;
    }

    public String getRequestFromResponse(String response, String address, String subjectId) throws Exception {
        LoginRequest jemRequest = null;
        if (response == null) {
            jemRequest = new LoginRequest();
            jemRequest.setAddress(address);
            jemRequest.setSubjectId(subjectId);
            RequestOperation op = new RequestOperation();
            op.setName(Operation.getPassword.toString());
            jemRequest.setOperation(op);
        } else {
            LoginResponse jemResponce = LoginResponse.unmarshall(response = new String(Base64.decode(response)));
            if (jemResponce.getException() != null) {
                this.serverException = true;
                return null;
            }
            if (jemResponce.getOperation().getName().equals(Operation.getPassword.toString())) {
                jemRequest = new LoginRequest();
                jemRequest.setAddress(address);
                jemRequest.setSubjectId(subjectId);
                String cryptPassword = Base64.encode(Crypto.crypt(jemResponce.getOperation().getResult().getBytes(), this.cryptographicKey), 1000);
                jemRequest.setPassword(cryptPassword);
                RequestOperation op = new RequestOperation();
                op.setName(Operation.login.toString());
                jemRequest.setOperation(op);
            } else {
                if (jemResponce.getOperation().getName().equals(Operation.login.toString())) {
                    if (jemResponce.getOperation().getResult().equals("denied")) {
                        throw new Exception(NodeMessage.JEMC106W.toMessage().getMessage());
                    }
                    if (jemResponce.getOperation().getResult().equals("accepted")) {
                        this.conversationTerminated = true;
                        return null;
                    }
                    this.conversationTerminated = true;
                    throw new Exception(NodeMessage.JEMC106W.toMessage().getMessage());
                }
                this.conversationTerminated = true;
                throw new Exception(NodeMessage.JEMC106W.toMessage().getMessage());
            }
        }
        String xmlRequest = LoginRequest.marshall(jemRequest);
        return Base64.encode(xmlRequest.getBytes(), 2 * xmlRequest.length());
    }

    public boolean isConversationTerminated() {
        return this.conversationTerminated;
    }

    public boolean isServerException() {
        return this.serverException;
    }
}

