/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.keystore;

import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.keystore.KeyStoreInfo;
import org.pepstock.jem.node.security.keystore.KeyStoreUtil;

public class KeysUtil {
    public static Key getSymmetricKey() throws Exception {
        return KeysUtil.getSymmetricKey(KeyStoreUtil.getKeyStoresInfo().getClusterKeystoreInfo());
    }

    public static Key getSymmetricKey(KeyStoreInfo keystoreInfo) throws Exception {
        KeyStore keystore = KeyStoreUtil.getKeystore(keystoreInfo);
        Key secretKey = keystore.getKey(keystoreInfo.getSymmetricKeyAlias(), keystoreInfo.getSymmetricKeyPwd().toCharArray());
        return secretKey;
    }

    public static PublicKey getPublicKeyByAlias(KeyStoreInfo keystoreInfo, String certAlias) throws Exception {
        KeyStore keystore = KeyStoreUtil.getKeystore(keystoreInfo);
        Certificate certificate = keystore.getCertificate(certAlias);
        if (certificate == null || !certificate.getType().equals("X.509")) {
            throw new Exception(NodeMessage.JEMC200E.toMessage().getFormattedMessage(certAlias));
        }
        Date expirationDate = ((X509Certificate)certificate).getNotAfter();
        if (expirationDate.before(new Date())) {
            throw new Exception(NodeMessage.JEMC201E.toMessage().getFormattedMessage(certAlias, expirationDate));
        }
        return certificate.getPublicKey();
    }
}

