/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.keystore;

import com.hazelcast.config.SocketInterceptorConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.security.Crypto;
import org.pepstock.jem.node.security.keystore.Factory;
import org.pepstock.jem.node.security.keystore.KeyStoreInfo;
import org.pepstock.jem.node.security.keystore.KeyStoresInfo;

public class KeyStoreUtil {
    private static KeyStoresInfo INFO = null;

    public static synchronized KeyStoresInfo getKeyStoresInfo() {
        if (INFO == null) {
            SocketInterceptorConfig config = Main.HAZELCAST.getConfig().getNetworkConfig().getSocketInterceptorConfig();
            INFO = Factory.createKeyStoresInfo(config);
        }
        return INFO;
    }

    static KeyStore getKeystore(KeyStoreInfo keystoreInfo) throws Exception {
        KeyStore keystore = KeyStore.getInstance(keystoreInfo.getType());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(keystoreInfo.getFile());
            keystore.load(fis, keystoreInfo.getPassword().toCharArray());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return keystore;
    }

    public static void generate(KeyStoreInfo keystoreInfo) throws Exception {
        KeyStore keystore = null;
        if (keystoreInfo.getFile().exists()) {
            keystore = KeyStoreUtil.getKeystore(keystoreInfo);
        } else {
            keystore = KeyStore.getInstance(keystoreInfo.getType());
            keystore.load(null, null);
            KeyStoreUtil.save(keystore, keystoreInfo);
        }
        if (keystoreInfo.getSymmetricKeyAlias() != null && keystoreInfo.getSymmetricKeyPwd() != null && keystore.getKey(keystoreInfo.getSymmetricKeyAlias(), keystoreInfo.getSymmetricKeyPwd().toCharArray()) == null) {
            SecretKey secretKey = Crypto.generateSymmetricKey();
            keystore.setKeyEntry(keystoreInfo.getSymmetricKeyAlias(), secretKey, keystoreInfo.getSymmetricKeyPwd().toCharArray(), null);
            KeyStoreUtil.save(keystore, keystoreInfo);
        }
    }

    static void save(KeyStore keystore, KeyStoreInfo info) throws Exception {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(info.getFile());
            keystore.store(os, info.getPassword().toCharArray());
            ((OutputStream)os).close();
            if (info.getBackupFile() != null) {
                KeyStoreUtil.getKeystore(info);
                FileUtils.copyFile((File)info.getFile(), (File)info.getBackupFile());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {}
            }
        }
    }
}

