/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.keystore;

import com.hazelcast.config.SocketInterceptorConfig;
import java.io.File;
import org.pepstock.jem.node.security.keystore.KeyStoreInfo;
import org.pepstock.jem.node.security.keystore.KeyStoresInfo;

public class Factory {
    public static final String JEM_KEYSTORE_PATH_PROP = "jem.keystore.path";
    public static final String USER_KEYSTORE_PATH_PROP = "jem.user.keystore.path";
    public static final String JEM_KEYSTORE_PWD_PROP = "jem.keystore.pwd";
    public static final String JEM_CRYPT_KEY_PWD_PROP = "jem.crypt.key.pwd";
    public static final String JEM_CRYPT_KEY_ALIAS_PROP = "jem.crypt.key.alias";
    public static final String KEYSTORES_FOLDER = "keystores";

    public static KeyStoresInfo createKeyStoresInfo(SocketInterceptorConfig config) {
        File clusterKeystoreFile = new File(config.getProperties().getProperty(JEM_KEYSTORE_PATH_PROP));
        File userKeystoreFile = new File(config.getProperties().getProperty(USER_KEYSTORE_PATH_PROP));
        String keystorePasswd = config.getProperties().getProperty(JEM_KEYSTORE_PWD_PROP);
        String keyPasswd = config.getProperties().getProperty(JEM_CRYPT_KEY_PWD_PROP);
        String keyAlias = config.getProperties().getProperty(JEM_CRYPT_KEY_ALIAS_PROP);
        KeyStoreInfo clusterKeystoreInfo = new KeyStoreInfo("JCEKS");
        clusterKeystoreInfo.setFile(clusterKeystoreFile);
        clusterKeystoreInfo.setBackupFile(new File(clusterKeystoreFile.getAbsolutePath() + ".backup"));
        clusterKeystoreInfo.setPassword(keystorePasswd);
        clusterKeystoreInfo.setSymmetricKeyAlias(keyAlias);
        clusterKeystoreInfo.setSymmetricKeyPwd(keyPasswd);
        KeyStoreInfo userKeystoreInfo = new KeyStoreInfo("JKS");
        userKeystoreInfo.setFile(userKeystoreFile);
        userKeystoreInfo.setBackupFile(new File(userKeystoreFile.getAbsolutePath() + ".backup"));
        userKeystoreInfo.setPassword(keystorePasswd);
        KeyStoresInfo keystoresInfo = new KeyStoresInfo();
        keystoresInfo.setClusterKeystoreInfo(clusterKeystoreInfo);
        keystoresInfo.setUserKeystoreInfo(userKeystoreInfo);
        return keystoresInfo;
    }
}

