/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security.keystore;

import com.hazelcast.core.ILock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.CertificateEntry;
import org.pepstock.jem.node.security.keystore.KeyStoreInfo;
import org.pepstock.jem.node.security.keystore.KeyStoreUtil;

public class CertificatesUtil {
    public static final String X509_CERTIFICATE_TYPE = "X.509";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CertificateEntry> getCertificates() throws Exception {
        ILock lock = Main.HAZELCAST.getLock((Object)"org.pepstock.jem.keystore");
        try {
            lock.lock();
            KeyStoreInfo info = KeyStoreUtil.getKeyStoresInfo().getUserKeystoreInfo();
            List<CertificateEntry> list = CertificatesUtil.getCertificates(info);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCertificate(byte[] certificate, String certificateAlias) throws Exception {
        block4: {
            ILock lock = Main.HAZELCAST.getLock((Object)"org.pepstock.jem.keystore");
            try {
                lock.lock();
                KeyStoreInfo info = KeyStoreUtil.getKeyStoresInfo().getUserKeystoreInfo();
                KeyStore keystore = KeyStoreUtil.getKeystore(info);
                if (!keystore.containsAlias(certificateAlias)) {
                    CertificatesUtil.insertCertificate(keystore, info, certificate, certificateAlias);
                    break block4;
                }
                throw new Exception("Alias '" + certificateAlias + "' is already present");
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCertificate(String certificateAlias) throws Exception {
        block4: {
            ILock lock = Main.HAZELCAST.getLock((Object)"org.pepstock.jem.keystore");
            try {
                lock.lock();
                KeyStoreInfo info = KeyStoreUtil.getKeyStoresInfo().getUserKeystoreInfo();
                KeyStore keystore = KeyStoreUtil.getKeystore(info);
                if (keystore.containsAlias(certificateAlias)) {
                    CertificatesUtil.removeAlias(keystore, info, certificateAlias);
                    break block4;
                }
                throw new Exception("Alias '" + certificateAlias + "' is not present");
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static void insertCertificate(KeyStore keystore, KeyStoreInfo info, byte[] certificate, String certificateAlias) throws Exception {
        ByteArrayInputStream fis = new ByteArrayInputStream(certificate);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        Certificate cert = cf.generateCertificate(bis);
        if (!cert.getType().equals(X509_CERTIFICATE_TYPE)) {
            throw new Exception(NodeMessage.JEMC200E.toMessage().getFormattedMessage(cert.getType()));
        }
        Date expirationDate = ((X509Certificate)cert).getNotAfter();
        if (expirationDate.before(new Date())) {
            throw new Exception(NodeMessage.JEMC201E.toMessage().getFormattedMessage(certificateAlias, expirationDate));
        }
        keystore.setCertificateEntry(certificateAlias, cert);
        KeyStoreUtil.save(keystore, info);
    }

    private static List<CertificateEntry> getCertificates(KeyStoreInfo info) throws Exception {
        KeyStore keystore = KeyStoreUtil.getKeystore(info);
        Enumeration<String> aliases = keystore.aliases();
        ArrayList<CertificateEntry> listCerts = new ArrayList<CertificateEntry>();
        while (aliases.hasMoreElements()) {
            String currAlias = aliases.nextElement();
            Certificate cert = keystore.getCertificate(currAlias);
            CertificateEntry keystoreEntry = new CertificateEntry();
            keystoreEntry.setAlias(currAlias);
            if (cert != null && cert.getType().equals(X509_CERTIFICATE_TYPE)) {
                X509Certificate certificate = (X509Certificate)cert;
                keystoreEntry.setIssuer(certificate.getIssuerDN().getName());
                keystoreEntry.setSubject(certificate.getSubjectDN().getName());
                keystoreEntry.setNotBefore(certificate.getNotBefore());
                keystoreEntry.setNotAfter(certificate.getNotAfter());
            }
            listCerts.add(keystoreEntry);
        }
        return listCerts;
    }

    private static void removeAlias(KeyStore keystore, KeyStoreInfo info, String alias) throws Exception {
        keystore.deleteEntry(alias);
        KeyStoreUtil.save(keystore, info);
    }
}

