/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.util.CollectionUtils;
import org.pepstock.jem.node.NodeMessage;

public class StringPermission
extends WildcardPermission
implements Permission,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Set<String>> parts;
    private String permission = null;

    public StringPermission() {
    }

    public StringPermission(String permission) {
        super(permission, false);
        this.setPermission(permission);
        this.load();
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    private void load() {
        if (this.permission == null || this.permission.trim().length() == 0) {
            throw new IllegalArgumentException(NodeMessage.JEMC129E.toMessage().getMessage());
        }
        this.permission = this.permission.trim();
        LinkedList<String> localParts = new LinkedList<String>();
        String[] permissionParts = this.permission.split(":");
        if (permissionParts.length == 1) {
            localParts.add(permissionParts[0]);
        } else if (permissionParts.length == 2) {
            localParts.add(permissionParts[0]);
            localParts.add(permissionParts[1]);
        } else {
            localParts.add(permissionParts[0]);
            localParts.add(permissionParts[1]);
            StringBuffer lastPart = new StringBuffer();
            for (int i = 2; i < permissionParts.length; ++i) {
                lastPart.append(permissionParts[i]);
            }
            localParts.add(lastPart.toString());
        }
        this.parts = new ArrayList<Set<String>>();
        for (String part : localParts) {
            Set subparts = CollectionUtils.asSet((Object[])part.split(","));
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException(NodeMessage.JEMC130E.toMessage().getMessage());
            }
            this.parts.add(subparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException(NodeMessage.JEMC131E.toMessage().getMessage());
        }
    }

    public List<Set<String>> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean implies(Permission p) {
        return super.implies(p);
    }

    public String toString() {
        return this.getPermission();
    }
}

