/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SecurityUtils {
    public static final int TO_BE_CHECKED = 1;
    public static final int TO_BE_IGNORED = 0;
    public static final int TO_BE_REJECTED = -1;
    private String dataPath = System.getProperty("jem.data");
    private String outputPath = System.getProperty("jem.output");
    private String sourcePath = System.getProperty("jem.source");
    private String libraryPath = System.getProperty("jem.library");
    private String binaryPath = System.getProperty("jem.binary");
    private String classPath = System.getProperty("jem.classpath");
    private String persistencePath = System.getProperty("jem.persistence");
    private String home = System.getProperty("JEM_HOME");
    private String temp = null;

    public SecurityUtils() {
        try {
            this.temp = FilenameUtils.normalize((String)File.createTempFile("security", "tmp").getParentFile().getAbsolutePath(), (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int checkReadFileName(String fileName) {
        boolean go;
        if (fileName.startsWith(this.dataPath)) {
            return 1;
        }
        boolean bl = go = fileName.startsWith(this.outputPath) || fileName.startsWith(this.sourcePath) || fileName.startsWith(this.libraryPath) || fileName.startsWith(this.binaryPath) || fileName.startsWith(this.classPath);
        if (go) {
            return 0;
        }
        if (fileName.startsWith(this.persistencePath)) {
            return -1;
        }
        String ext = FilenameUtils.getExtension((String)fileName);
        if (ext.equalsIgnoreCase("class") || ext.equalsIgnoreCase("jar") || ext.equalsIgnoreCase("zip")) {
            return 0;
        }
        if (fileName.startsWith(this.home) && FilenameUtils.wildcardMatch((String)fileName, (String)(this.home + File.separator + "*" + File.separator + "config*"))) {
            return -1;
        }
        return 0;
    }

    public int checkWriteFileName(String fileName) {
        boolean go;
        if (fileName.endsWith("root.properties")) {
            return -1;
        }
        boolean bl = go = fileName.startsWith(this.dataPath) || fileName.startsWith(this.sourcePath) || fileName.startsWith(this.libraryPath) || fileName.startsWith(this.binaryPath) || fileName.startsWith(this.classPath);
        if (go) {
            return 1;
        }
        if (fileName.startsWith(this.temp)) {
            return 0;
        }
        if (fileName.startsWith(this.outputPath)) {
            if (FilenameUtils.getFullPathNoEndSeparator((String)fileName).equalsIgnoreCase(this.outputPath)) {
                return -1;
            }
            return 0;
        }
        if (fileName.startsWith(this.home)) {
            return -1;
        }
        if (fileName.startsWith(this.persistencePath)) {
            return -1;
        }
        return -1;
    }

    public String normalizeFileName(String fileName) {
        if (fileName.startsWith(this.dataPath)) {
            String file = StringUtils.substringAfter((String)fileName, (String)this.dataPath);
            if (FilenameUtils.separatorsToSystem((String)file).startsWith(File.separator)) {
                return file.substring(1);
            }
            return file;
        }
        return fileName;
    }
}

