/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.util.CollectionUtils;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.StringPermission;

public class RegExpPermission
implements Permission,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    protected static final boolean DEFAULT_CASE_SENSITIVE = false;
    private List<Set<Pattern>> parts;
    private String permissionPattern = null;
    private boolean caseSensitive = false;

    public RegExpPermission() {
    }

    public RegExpPermission(String permissionPattern) {
        this(permissionPattern, false);
    }

    public RegExpPermission(String permissionPattern, boolean caseSensitive) {
        this.setPermissionPattern(permissionPattern);
        this.setCaseSensitive(caseSensitive);
        this.load();
    }

    public String getPermissionPattern() {
        return this.permissionPattern;
    }

    public void setPermissionPattern(String permissionPattern) {
        this.permissionPattern = permissionPattern;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private void load() {
        if (this.permissionPattern == null || this.permissionPattern.trim().length() == 0) {
            throw new IllegalArgumentException(NodeMessage.JEMC129E.toMessage().getMessage());
        }
        this.permissionPattern = this.permissionPattern.trim();
        List parts = CollectionUtils.asList((Object[])this.permissionPattern.split(PART_DIVIDER_TOKEN));
        this.parts = new ArrayList<Set<Pattern>>();
        for (String part : parts) {
            Set subparts = CollectionUtils.asSet((Object[])part.split(SUBPART_DIVIDER_TOKEN));
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException(NodeMessage.JEMC130E.toMessage().getMessage());
            }
            LinkedHashSet<Pattern> patternSubparts = new LinkedHashSet<Pattern>(subparts.size());
            for (String subpart : subparts) {
                Pattern pattern = this.caseSensitive ? Pattern.compile(subpart.trim()) : Pattern.compile(subpart.trim(), 2);
                patternSubparts.add(pattern);
            }
            this.parts.add(patternSubparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException(NodeMessage.JEMC131E.toMessage().getMessage());
        }
    }

    private List<Set<Pattern>> getParts() {
        return this.parts;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof StringPermission)) {
            return false;
        }
        StringPermission stringPermission = (StringPermission)p;
        List<Set<String>> otherParts = stringPermission.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set<Pattern> part = this.getParts().get(i);
            boolean or = part.size() > 1;
            for (String stringPart : otherPart) {
                boolean matches = false;
                for (Pattern pattern : part) {
                    boolean match = pattern.matcher(stringPart).matches();
                    if (!or) {
                        if (match) continue;
                        return false;
                    }
                    matches = matches || match;
                }
                if (!or || matches) continue;
                return false;
            }
            ++i;
        }
        return true;
    }
}

