/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.node.NodeMessage;

public class Crypto {
    private static final String DESEDE_ALGORITHM = "DESede";

    public static Key loadPrivateKeyFromFile(File pemKeyFile, String password) throws Exception {
        KeyPair kp;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        PEMParser pemParser = new PEMParser((Reader)new FileReader(pemKeyFile));
        Object object = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        if (object instanceof PEMEncryptedKeyPair) {
            if (password == null) {
                throw new Exception(NodeMessage.JEMC205E.toMessage().getMessage());
            }
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            kp = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv));
        } else {
            LogAppl.getInstance().emit(NodeMessage.JEMC199W);
            kp = converter.getKeyPair((PEMKeyPair)object);
        }
        return kp.getPrivate();
    }

    public static byte[] crypt(byte[] text, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        byte[] plaintext = text;
        byte[] ciphertext = cipher.doFinal(plaintext);
        return ciphertext;
    }

    public static byte[] decrypt(byte[] encryptText, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        byte[] text = cipher.doFinal(encryptText);
        return text;
    }

    public static SecretKey generateSymmetricKey() throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance(DESEDE_ALGORITHM);
        keygen.init(168);
        return keygen.generateKey();
    }
}

