/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.security.RegExpPermission;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.SecurityUtils;
import org.pepstock.jem.node.security.StringPermission;

public abstract class BatchSecurityManager
extends SecurityManager {
    private List<Permission> permissions;
    private SecurityUtils utils = new SecurityUtils();

    public BatchSecurityManager(Collection<Role> roles) {
        this.loadPermissions(roles);
    }

    private void loadPermissions(Collection<Role> roles) {
        this.permissions = new ArrayList<Permission>();
        for (Role role : roles) {
            for (String permission : role.getPermissions()) {
                Permission perm = null;
                perm = permission.equalsIgnoreCase("files:read:*") || permission.equalsIgnoreCase("files:write:*") || permission.equalsIgnoreCase("files:execute:*") ? new StringPermission(permission) : (permission.startsWith("files:read:") || permission.startsWith("files:write:") || permission.startsWith("files:execute:") ? new RegExpPermission(permission) : new StringPermission(permission));
                this.permissions.add(perm);
            }
        }
    }

    public boolean checkBatchPermission(String permission) {
        StringPermission sPermission = new StringPermission(permission);
        for (Permission perm : this.permissions) {
            if (!perm.implies((Permission)sPermission)) continue;
            return true;
        }
        return false;
    }

    public final boolean checkResource(Resource resource) {
        String permission = "datasources:" + resource.getType() + ":" + resource.getName();
        return this.checkBatchPermission(permission);
    }

    public final boolean checkNodesCommand(String permission) {
        return this.checkBatchPermission(permission);
    }

    @Override
    public void checkPermission(java.security.Permission perm) {
    }

    @Override
    public final void checkPermission(java.security.Permission perm, Object context) {
        this.checkPermission(perm);
    }

    @Override
    public void checkExit(int status) {
    }

    @Override
    public final void checkExec(String cmd) {
        String permission = "files:execute:" + FilenameUtils.normalize((String)cmd, (boolean)true);
        if (!this.checkBatchPermission(permission)) {
            System.out.println(NodeMessage.JEMC104E.toMessage().getFormattedMessage(cmd));
            throw new SecurityException(NodeMessage.JEMC104E.toMessage().getFormattedMessage(cmd));
        }
    }

    @Override
    public void checkRead(String file) {
        String normalizedFile = FilenameUtils.normalize((String)file, (boolean)true);
        int result = this.utils.checkReadFileName(normalizedFile);
        if (result == 1) {
            if (!this.checkBatchPermission("files:read:" + this.utils.normalizeFileName(normalizedFile))) {
                System.out.println(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
            }
            throw new SecurityException(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
        }
        if (result == -1) {
            System.out.println(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
            throw new SecurityException(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
        }
    }

    @Override
    public final void checkRead(String file, Object context) {
        this.checkRead(file);
    }

    @Override
    public void checkWrite(String file) {
        String normalizedFile = FilenameUtils.normalize((String)file, (boolean)true);
        int result = this.utils.checkWriteFileName(normalizedFile);
        if (result == 1) {
            if (!this.checkBatchPermission("files:write:" + this.utils.normalizeFileName(normalizedFile))) {
                System.out.println(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
            }
            throw new SecurityException(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
        }
        if (result == -1) {
            System.out.println(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
            throw new SecurityException(NodeMessage.JEMC104E.toMessage().getFormattedMessage(normalizedFile));
        }
    }

    @Override
    public final void checkDelete(String file) {
        this.checkWrite(file);
    }
}

