/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.rmi;

import com.hazelcast.core.IMap;
import java.rmi.RemoteException;
import java.util.Collection;
import org.pepstock.jem.Job;
import org.pepstock.jem.Result;
import org.pepstock.jem.Step;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.JobLogManager;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.rmi.TasksDoor;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.util.rmi.DefaultRmiObject;

public class TasksDoorImpl
extends DefaultRmiObject
implements TasksDoor {
    private static final long serialVersionUID = 1L;

    @Override
    public Collection<Role> setJobStarted(String processId) throws RemoteException {
        Main.CURRENT_TASK.setProcessId(processId);
        Job job = Main.CURRENT_TASK.getJobTask().getJob();
        job.setProcessId(processId);
        IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
        try {
            runningQueue.lock((Object)job.getId());
            if (runningQueue.containsKey((Object)job.getId())) {
                Job storedJob = (Job)runningQueue.get((Object)job.getId());
                storedJob.setProcessId(processId);
                runningQueue.replace((Object)storedJob.getId(), (Object)storedJob);
            } else {
                runningQueue.put((Object)job.getId(), (Object)job);
            }
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        finally {
            runningQueue.unlock((Object)job.getId());
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC022I, job.toString(), processId);
        JobLogManager.printJobStarted(job);
        return Main.CURRENT_TASK.getJobTask().getRoles();
    }

    @Override
    public void setStepStarted(Step step) throws RemoteException {
        Job job = Main.CURRENT_TASK.getJobTask().getJob();
        job.setCurrentStep(step);
        IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
        try {
            runningQueue.lock((Object)job.getId());
            Job storedJob = (Job)runningQueue.get((Object)job.getId());
            storedJob.setCurrentStep(step);
            runningQueue.replace((Object)storedJob.getId(), (Object)storedJob);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        finally {
            runningQueue.unlock((Object)job.getId());
        }
    }

    @Override
    public void setStepEnded(Step step) throws RemoteException {
        Result result = Main.CURRENT_TASK.getJobTask().getResult();
        if (result.getReturnCode() < step.getReturnCode()) {
            result.setReturnCode(step.getReturnCode());
            result.setExceptionMessage(step.getException());
        }
        Job job = Main.CURRENT_TASK.getJobTask().getJob();
        JobLogManager.printStepResult(job, step);
    }

    @Override
    public void setJobEnded() throws RemoteException {
    }
}

