/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.rmi;

import com.hazelcast.core.IMap;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.pepstock.jem.Job;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.RequestLock;
import org.pepstock.jem.node.ResourceLock;
import org.pepstock.jem.node.rmi.ResourceLocker;
import org.pepstock.jem.util.rmi.DefaultRmiObject;

public class ResourceLockerImpl
extends DefaultRmiObject
implements ResourceLocker {
    private static final long serialVersionUID = 1L;
    private RequestLock request = Main.NODE.getRequest();

    @Override
    public boolean alive() throws RemoteException {
        return true;
    }

    @Override
    public void lock(ArrayList<ResourceLock> resources) throws RemoteException {
        Job storedJob;
        Job job = Main.CURRENT_TASK.getJobTask().getJob();
        for (ResourceLock resource : resources) {
            if (this.request.getResources().containsKey(resource.getName())) {
                if (resource.getMode() != 1) continue;
                this.request.getResources().put(resource.getName(), resource);
                continue;
            }
            this.request.getResources().put(resource.getName(), resource);
        }
        IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
        try {
            runningQueue.lock((Object)job.getId());
            storedJob = (Job)runningQueue.get((Object)job.getId());
            storedJob.setRunningStatus(-1);
            job.setRunningStatus(-1);
            runningQueue.replace((Object)storedJob.getId(), (Object)storedJob);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        finally {
            runningQueue.unlock((Object)job.getId());
        }
        try {
            this.request.tryLock();
        }
        catch (InterruptedException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        try {
            runningQueue.lock((Object)job.getId());
            storedJob = (Job)runningQueue.get((Object)job.getId());
            storedJob.setRunningStatus(1);
            job.setRunningStatus(1);
            runningQueue.replace((Object)storedJob.getId(), (Object)storedJob);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
        finally {
            runningQueue.unlock((Object)job.getId());
        }
        NodeInfoUtility.storeNodeInfo(Main.NODE);
    }

    @Override
    public void unlock() throws RemoteException {
        this.request.unlock();
        this.request.getResources().clear();
        NodeInfoUtility.storeNodeInfo(Main.NODE);
    }
}

