/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.rmi;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.pepstock.jem.Job;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.util.rmi.DefaultRmiObject;

public class AuthorizedDefaultRmiObject
extends DefaultRmiObject {
    private static final long serialVersionUID = 1L;

    public void checkAuthorization(String permissionToCheck) throws RemoteException {
        ArrayList<Role> roles = Main.CURRENT_TASK.getJobTask().getRoles();
        for (Role role : roles) {
            if (role.getName().equalsIgnoreCase("administrator")) {
                return;
            }
            StringPermission permissionToHave = new StringPermission(permissionToCheck);
            for (String permission : role.getPermissions()) {
                StringPermission perm = new StringPermission(permission);
                if (!perm.implies(permissionToHave)) continue;
                return;
            }
        }
        String userid = null;
        Job job = Main.CURRENT_TASK.getJobTask().getJob();
        userid = job.isUserSurrogated() ? job.getJcl().getUser() : job.getUser();
        throw new RemoteException(NodeMessage.JEMC121E.toMessage().getFormattedMessage(userid, permissionToCheck));
    }
}

