/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.resources.custom.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;
import org.pepstock.jem.node.resources.custom.ResourceMessage;
import org.pepstock.jem.node.resources.custom.SectionDescriptor;
import org.pepstock.jem.node.resources.custom.engine.ResourceTemplateException;
import org.pepstock.jem.node.resources.custom.engine.xml.AbstractFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.MultiSelectableListFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.ResourceTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.ResourceTemplates;
import org.pepstock.jem.node.resources.custom.engine.xml.SectionTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.SingleSelectableListFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.TextFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.ValueTemplate;
import org.pepstock.jem.node.resources.custom.fields.AbstractFieldDescriptor;
import org.pepstock.jem.node.resources.custom.fields.MultiSelectableListFieldDescriptor;
import org.pepstock.jem.node.resources.custom.fields.SingleSelectableListFieldDescriptor;
import org.pepstock.jem.node.resources.custom.fields.TextFieldDescriptor;

public class ResourceTemplatesFactory {
    public static Iterator<ResourceDescriptor> buildResourceDescriptors(ResourceTemplates resourceTemplates) throws ResourceTemplateException {
        if (null == resourceTemplates) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "ResourceDescriptor Iterator", "ResourceTemplates");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("ResourceDescriptor Iterator", "ResourceTemplates"));
        }
        ArrayList<ResourceDescriptor> resources = new ArrayList<ResourceDescriptor>();
        Iterator<ResourceTemplate> templates = resourceTemplates.getContent().iterator();
        while (templates.hasNext()) {
            ResourceDescriptor resource = ResourceTemplatesFactory.buildResourceDescriptor(templates.next());
            resources.add(resource);
        }
        return resources.iterator();
    }

    public static ResourceDescriptor buildResourceDescriptor(ResourceTemplate resourceTemplate) throws ResourceTemplateException {
        if (null == resourceTemplate) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "ResourceDescriptor", "ResourceTemplate");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("ResourceDescriptor", "ResourceTemplate"));
        }
        if (null == resourceTemplate.getType()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "ResourceDescriptor", "ResourceTemplate Type");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("ResourceDescriptor", "ResourceTemplate Type"));
        }
        ResourceDescriptor resource = new ResourceDescriptor(resourceTemplate.getType());
        LinkedList<SectionTemplate> sectionTemplates = resourceTemplate.getContent();
        for (int i = 0; i < sectionTemplates.size(); ++i) {
            SectionDescriptor section = ResourceTemplatesFactory.buildSectionDescriptor(sectionTemplates.get(i));
            resource.addSections(section);
        }
        return resource;
    }

    private static SectionDescriptor buildSectionDescriptor(SectionTemplate sectionTemplate) throws ResourceTemplateException {
        if (null == sectionTemplate) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "SectionDescriptor", "SectionTemplate");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("SectionDescriptor", "SectionTemplate"));
        }
        SectionDescriptor section = null;
        section = null == sectionTemplate.getName() ? new SectionDescriptor() : new SectionDescriptor(sectionTemplate.getName());
        LinkedList<AbstractFieldTemplate> abstractFieldTemplates = sectionTemplate.getContent();
        for (int i = 0; i < abstractFieldTemplates.size(); ++i) {
            AbstractFieldDescriptor field = ResourceTemplatesFactory.buildFieldDescriptor(abstractFieldTemplates.get(i));
            section.addFields(field);
        }
        return section;
    }

    private static AbstractFieldDescriptor buildFieldDescriptor(AbstractFieldTemplate abstractFieldTemplate) throws ResourceTemplateException {
        if (null == abstractFieldTemplate) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "FieldDescriptor", "FieldTemplate");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("FieldDescriptor", "FieldTemplate"));
        }
        if (abstractFieldTemplate instanceof TextFieldTemplate) {
            return ResourceTemplatesFactory.buildTextFieldDescriptor((TextFieldTemplate)abstractFieldTemplate);
        }
        if (abstractFieldTemplate instanceof SingleSelectableListFieldTemplate) {
            return ResourceTemplatesFactory.buildSingleSelectableListFieldDescriptor((SingleSelectableListFieldTemplate)abstractFieldTemplate);
        }
        if (abstractFieldTemplate instanceof MultiSelectableListFieldTemplate) {
            return ResourceTemplatesFactory.buildMultiSelectableListFieldDescriptor((MultiSelectableListFieldTemplate)abstractFieldTemplate);
        }
        LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR008E, abstractFieldTemplate.getClass().getName());
        throw new ResourceTemplateException(ResourceMessage.JEMR008E.toMessage().getFormattedMessage(abstractFieldTemplate.getClass().getName()));
    }

    private static TextFieldDescriptor buildTextFieldDescriptor(TextFieldTemplate textFieldTemplate) throws ResourceTemplateException {
        if (null == textFieldTemplate.getKey()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "TextFieldDescriptor", "FieldTemplate Key");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("TextFieldDescriptor", "FieldTemplate Key"));
        }
        if (null == textFieldTemplate.getLabel()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "TextFieldDescriptor", "FieldTemplate Label");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("TextFieldDescriptor", "FieldTemplate Label"));
        }
        TextFieldDescriptor textField = new TextFieldDescriptor(textFieldTemplate.getKey(), textFieldTemplate.getLabel());
        if (null != textFieldTemplate.getDescription()) {
            textField.setDescription(textFieldTemplate.getDescription());
        }
        if (textFieldTemplate.isMandatory()) {
            textField.setMandatory(textFieldTemplate.isMandatory());
        }
        if (null != textFieldTemplate.getDefaultValue()) {
            textField.setDefaultValue(textFieldTemplate.getDefaultValue());
        }
        if (null != textFieldTemplate.getRegExValidator()) {
            textField.setRegExValidator(textFieldTemplate.getRegExValidator());
        }
        return textField;
    }

    private static SingleSelectableListFieldDescriptor buildSingleSelectableListFieldDescriptor(SingleSelectableListFieldTemplate singleSelectableListFieldTemplate) throws ResourceTemplateException {
        if (null == singleSelectableListFieldTemplate.getKey()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "TextFieldDescriptor", "FieldTemplate Key");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("TextFieldDescriptor", "FieldTemplate Key"));
        }
        if (null == singleSelectableListFieldTemplate.getLabel()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "TextFieldDescriptor", "FieldTemplate Label");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("TextFieldDescriptor", "FieldTemplate Label"));
        }
        if (null == singleSelectableListFieldTemplate.getContent() || singleSelectableListFieldTemplate.getContent().size() == 0) {
            LogAppl.getInstance().emit(ResourceMessage.JEMR009E);
            throw new ResourceTemplateException(ResourceMessage.JEMR009E.toMessage().getMessage());
        }
        String defaultValue = singleSelectableListFieldTemplate.getDefaultValue();
        LinkedList<ValueTemplate> valueTemplates = singleSelectableListFieldTemplate.getContent();
        String[] values = new String[valueTemplates.size()];
        boolean foundDefaultValue = false;
        for (int i = 0; i < valueTemplates.size(); ++i) {
            ValueTemplate valueTemplate = valueTemplates.get(i);
            if (null != defaultValue && defaultValue.equals(valueTemplate.getContent())) {
                foundDefaultValue = true;
            }
            values[i] = valueTemplate.getContent();
        }
        if (null != defaultValue && !foundDefaultValue) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR010E, defaultValue);
            throw new ResourceTemplateException(ResourceMessage.JEMR010E.toMessage().getFormattedMessage(defaultValue));
        }
        SingleSelectableListFieldDescriptor singleSelectableListField = new SingleSelectableListFieldDescriptor(singleSelectableListFieldTemplate.getKey(), singleSelectableListFieldTemplate.getLabel(), values);
        if (null != defaultValue) {
            singleSelectableListField.setDefaultValue(defaultValue);
        }
        if (null != singleSelectableListFieldTemplate.getDescription()) {
            singleSelectableListField.setDescription(singleSelectableListFieldTemplate.getDescription());
        }
        if (singleSelectableListFieldTemplate.isMandatory()) {
            singleSelectableListField.setMandatory(singleSelectableListFieldTemplate.isMandatory());
        }
        if (singleSelectableListFieldTemplate.isRenderAsRadio()) {
            singleSelectableListField.setRenderAsRadio(singleSelectableListFieldTemplate.isRenderAsRadio());
        }
        return singleSelectableListField;
    }

    private static MultiSelectableListFieldDescriptor buildMultiSelectableListFieldDescriptor(MultiSelectableListFieldTemplate multiSelectableListFieldTemplate) throws ResourceTemplateException {
        if (null == multiSelectableListFieldTemplate.getKey()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "TextFieldDescriptor", "FieldTemplate Key");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("TextFieldDescriptor", "FieldTemplate Key"));
        }
        if (null == multiSelectableListFieldTemplate.getLabel()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR007E, "TextFieldDescriptor", "FieldTemplate Label");
            throw new ResourceTemplateException(ResourceMessage.JEMR007E.toMessage().getFormattedMessage("TextFieldDescriptor", "FieldTemplate Label"));
        }
        if (null == multiSelectableListFieldTemplate.getContent() || multiSelectableListFieldTemplate.getContent().size() == 0) {
            LogAppl.getInstance().emit(ResourceMessage.JEMR009E);
            throw new ResourceTemplateException(ResourceMessage.JEMR009E.toMessage().getMessage());
        }
        MultiSelectableListFieldDescriptor multiSelectableListField = new MultiSelectableListFieldDescriptor(multiSelectableListFieldTemplate.getKey(), multiSelectableListFieldTemplate.getLabel());
        LinkedList<ValueTemplate> valueTemplates = multiSelectableListFieldTemplate.getContent();
        for (int i = 0; i < valueTemplates.size(); ++i) {
            ValueTemplate valueTemplate = valueTemplates.get(i);
            String value = valueTemplate.getContent();
            multiSelectableListField.setValues(value);
            if (!valueTemplate.isSelected()) continue;
            multiSelectableListField.setDefaultValues(value);
        }
        if (null != multiSelectableListFieldTemplate.getDescription()) {
            multiSelectableListField.setDescription(multiSelectableListFieldTemplate.getDescription());
        }
        if (multiSelectableListFieldTemplate.isMandatory()) {
            multiSelectableListField.setMandatory(multiSelectableListFieldTemplate.isMandatory());
        }
        return multiSelectableListField;
    }
}

