/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.resources.custom.engine;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;
import org.pepstock.jem.node.resources.custom.ResourceMessage;
import org.pepstock.jem.node.resources.custom.XmlConfigurationResourceDefinition;
import org.pepstock.jem.node.resources.custom.engine.ResourceTemplateException;
import org.pepstock.jem.node.resources.custom.engine.ResourceTemplatesFactory;
import org.pepstock.jem.node.resources.custom.engine.ValueConverter;
import org.pepstock.jem.node.resources.custom.engine.xml.AbstractFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.MultiSelectableListFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.ResourceTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.SectionTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.SingleSelectableListFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.SingleValueFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.TextFieldTemplate;
import org.pepstock.jem.node.resources.custom.engine.xml.ValueTemplate;

public class ResourceTemplateReader
extends FileAlterationListenerAdaptor {
    private static final long CHECK_INTERVAL = 60000L;
    private ResourceTemplate resourceTemplate = null;
    private ResourceDescriptor resourceDescriptor = null;
    private File resourceTemplateFile;
    private XStream xstream;
    private FileAlterationObserver resourceTemplateFileObserver;
    private boolean automaticControlStarted = false;
    private XmlConfigurationResourceDefinition xmlConfigurationResourceDefinition = null;

    public ResourceTemplateReader(String resourceTemplateFile, XmlConfigurationResourceDefinition xmlConfigurationResourceDefinition) throws ResourceTemplateException {
        this.resourceTemplateFile = new File(resourceTemplateFile);
        this.xmlConfigurationResourceDefinition = xmlConfigurationResourceDefinition;
        if (null == this.resourceTemplateFile.getParentFile() || !this.resourceTemplateFile.getParentFile().exists() || !this.resourceTemplateFile.getParentFile().isDirectory() || this.resourceTemplateFile.getParentFile().toString().equalsIgnoreCase(File.separator)) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR001E, this.resourceTemplateFile.getParentFile());
            throw new ResourceTemplateException(ResourceMessage.JEMR001E.toMessage().getFormattedMessage(this.resourceTemplateFile.getParentFile()));
        }
        if (!this.resourceTemplateFile.exists()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR002W, this.resourceTemplateFile, this.resourceTemplateFile.getParentFile());
            throw new ResourceTemplateException(ResourceMessage.JEMR002W.toMessage().getFormattedMessage(this.resourceTemplateFile, this.resourceTemplateFile.getParentFile()));
        }
        this.xstream = new XStream();
    }

    public ResourceTemplateReader(String resourceTemplateFile) throws ResourceTemplateException {
        this(resourceTemplateFile, null);
    }

    private ResourceTemplate getResourceTemplate() throws ResourceTemplateException {
        if (!this.automaticControlStarted) {
            this.readResourceTemplate();
        }
        if (null == this.resourceTemplate) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR005E, this.resourceTemplateFile);
            throw new ResourceTemplateException(ResourceMessage.JEMR005E.toMessage().getFormattedMessage(this.resourceTemplateFile));
        }
        return this.resourceTemplate;
    }

    public ResourceDescriptor getResourceDescriptor() throws ResourceTemplateException {
        if (!this.automaticControlStarted) {
            this.readResourceTemplate();
        }
        if (null == this.resourceDescriptor) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR005E, this.resourceTemplateFile);
            throw new ResourceTemplateException(ResourceMessage.JEMR005E.toMessage().getFormattedMessage(this.resourceTemplateFile));
        }
        return this.resourceDescriptor;
    }

    public void initialize() {
        this.aliasXml(this.xstream);
        this.resourceTemplateFileObserver = new FileAlterationObserver(this.resourceTemplateFile.getParentFile());
        this.resourceTemplateFileObserver.addListener((FileAlterationListener)this);
        FileAlterationMonitor fileMonitor = new FileAlterationMonitor(60000L);
        fileMonitor.addObserver(this.resourceTemplateFileObserver);
        try {
            this.readResourceTemplate();
        }
        catch (ResourceTemplateException ex) {
            LogAppl.getInstance().emit(ResourceMessage.JEMR003E);
        }
        try {
            fileMonitor.start();
            this.automaticControlStarted = true;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR004E, ex, this.resourceTemplateFile);
        }
    }

    private void aliasXml(XStream xstream) {
        xstream.registerConverter((Converter)new ValueConverter());
        xstream.alias("resource-template", ResourceTemplate.class);
        xstream.alias("section", SectionTemplate.class);
        xstream.alias("text-field", TextFieldTemplate.class);
        xstream.alias("single-selectable-list-field", SingleSelectableListFieldTemplate.class);
        xstream.alias("multi-selectable-list-field", MultiSelectableListFieldTemplate.class);
        xstream.alias("value", ValueTemplate.class);
        xstream.useAttributeFor(ResourceTemplate.class, "type");
        xstream.aliasField("section", ResourceTemplate.class, "sections");
        xstream.addImplicitCollection(ResourceTemplate.class, "sections");
        xstream.useAttributeFor(SectionTemplate.class, "name");
        xstream.aliasField("text-field", SectionTemplate.class, "fields");
        xstream.aliasField("single-selectable-list-field", SectionTemplate.class, "fields");
        xstream.aliasField("multi-selectable-list-field", SectionTemplate.class, "fields");
        xstream.addImplicitCollection(SectionTemplate.class, "fields");
        xstream.useAttributeFor(AbstractFieldTemplate.class, "key");
        xstream.useAttributeFor(AbstractFieldTemplate.class, "label");
        xstream.useAttributeFor(AbstractFieldTemplate.class, "description");
        xstream.useAttributeFor(AbstractFieldTemplate.class, "mandatory");
        xstream.useAttributeFor(SingleValueFieldTemplate.class, "defaultValue");
        xstream.useAttributeFor(TextFieldTemplate.class, "regExValidator");
        xstream.useAttributeFor(SingleSelectableListFieldTemplate.class, "renderAsRadio");
        xstream.aliasField("value", SingleSelectableListFieldTemplate.class, "values");
        xstream.addImplicitCollection(SingleSelectableListFieldTemplate.class, "values");
        xstream.aliasField("value", MultiSelectableListFieldTemplate.class, "values");
        xstream.addImplicitCollection(MultiSelectableListFieldTemplate.class, "values");
        xstream.useAttributeFor(ValueTemplate.class, "selected");
    }

    private void readResourceTemplate() throws ResourceTemplateException {
        try {
            FileInputStream fis = new FileInputStream(this.resourceTemplateFile);
            ResourceTemplate template = (ResourceTemplate)this.xstream.fromXML((InputStream)fis);
            fis.close();
            this.resourceTemplate = template;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR005E, ex, this.resourceTemplateFile);
            throw new ResourceTemplateException(ResourceMessage.JEMR005E.toMessage().getFormattedMessage(this.resourceTemplateFile), ex);
        }
        this.resourceDescriptor = ResourceTemplatesFactory.buildResourceDescriptor(this.resourceTemplate);
        LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR021I, this.resourceDescriptor.getType(), this.resourceTemplateFile);
        if (null != this.xmlConfigurationResourceDefinition) {
            this.xmlConfigurationResourceDefinition.setResourceDescriptor(this.resourceDescriptor);
        }
    }

    public String resourceTemplateToString() {
        try {
            ResourceTemplate resourceTemplate = this.getResourceTemplate();
            return this.xstream.toXML((Object)resourceTemplate);
        }
        catch (ResourceTemplateException rtEx) {
            return "<null/>";
        }
    }

    public void onFileChange(File file) {
        if (file.equals(this.resourceTemplateFile)) {
            try {
                this.readResourceTemplate();
            }
            catch (ResourceTemplateException ex) {
                LogAppl.getInstance().emit(ResourceMessage.JEMR003E);
            }
        }
    }

    public void onFileCreate(File file) {
        if (file.equals(this.resourceTemplateFile)) {
            try {
                this.readResourceTemplate();
            }
            catch (ResourceTemplateException ex) {
                LogAppl.getInstance().emit(ResourceMessage.JEMR003E);
            }
        }
    }

    public void onFileDelete(File file) {
        if (file.equals(this.resourceTemplateFile)) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR006W, this.resourceTemplateFile, this.resourceTemplateFile.getParentFile());
        }
    }
}

